<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use AppBundle\Entity\Inscription;
use AppBundle\Entity\Payment;
use AppBundle\Entity\Lead;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use AppBundle\Entity\OrcamentoContato;
use AppBundle\Form\OrcamentoContatoType;
use AppBundle\Entity\IndiqueCursos;
use AppBundle\Form\IndiqueCursosType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;

class TesteController extends BaseController
{
    /**
     * @Route("/soap/teste-1", name="soap_teste_1")
     */
    public function soapTesteAction(Request $request)
    {
      $client = new \SoapClient("http://dev.unimed.com.br/app_dev.php/api/soap/test/?wsdl");
      $response = $client->checkAction('Chuck');
      var_dump($response);

    }

    /**
     * @Route("/soap/teste-2", name="soap_teste_2")
     */
    public function soapTeste2Action(Request $request)
    {
      $opts = array('http' => array('user_agent' => 'PHPSoapClient'));
      $context = stream_context_create($opts);
      $client = new \SoapClient("http://dev.unimed.com.br/app_dev.php/api/soap/test/?wsdl", array(
          'stream_context' => $context,
          'exceptions' => true,
          'cache_wsdl' => WSDL_CACHE_NONE,
          'encoding'  => 'ISO-8859-1',
          'trace'     => true,
      ));
      $response = $client->listAction();
      var_dump($response);

    }

    /**
     * @Route("/soap/teste-3", name="soap_teste_3")
     */
    public function soapTeste3Action(Request $request)
    {
      $client = new \SoapClient("http://dev.unimed.com.br/app_dev.php/api/soap/test/stackoverflower?wsdl", array("trace" => 1, "exception" => 1));
      $result = $client->getList();
      var_dump($result);

    }


}
