<?php

namespace AppBundle\Controller;

use JMS\Serializer\SerializerBuilder;
use Symfony\Component\HttpFoundation\Request;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use AppBundle\Entity\Inscription;
use AppBundle\Entity\Payment;
use AppBundle\Entity\Client;
use AppBundle\Entity\JobRole;
use AppBundle\Entity\Sector;
use AppBundle\Entity\Lead;
use UserBundle\Entity\User;
use AppBundle\Entity\UserStatus;
use AppBundle\Entity\Contact;
use AppBundle\Entity\ClientLearningTrail;
use AppBundle\Form\ClientType;
use AppBundle\Form\ContactType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use AppBundle\Entity\OrcamentoContato;
use AppBundle\Form\OrcamentoContatoType;
use AppBundle\Entity\IndiqueCursos;
use AppBundle\Form\IndiqueCursosType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;
use AppBundle\Entity\InscriptionStatus;

class TimelineController extends BaseController
{

    /**
     * @Route("/timeline", name="timeline_index")
     */
    public function indexAction(Request $request)
    {
        $this->validUser();
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $client = $this->getClient($user);
        if ($client == null) {
            $entitiesLearningTrail = $em->getRepository('AppBundle:LearningTrail')->findAvailable($user);
        } else {
            $entitiesLearningTrail = $em->getRepository('AppBundle:LearningTrail')->findAvailable($client, true);
            $learningTrails = array();
            foreach ($entitiesLearningTrail as $learningTrail) {
                $learningTrailFilter = $learningTrail->getLearningTrailFilter();
                if ($learningTrailFilter) {
                    $sectors = $this->getIdCollectionItens($learningTrailFilter->getSectors());
                    $jobRoles = $this->getIdCollectionItens($learningTrailFilter->getJobRoles());
                    $managements = $this->getIdCollectionItens($learningTrailFilter->getManagements());

                    if ($this->checkPropertyInCollection($client->getSector(), $sectors)
                        && $this->checkPropertyInCollection($client->getJobRole(), $jobRoles)
                        && $this->checkPropertyInCollection($client->getManagement(), $managements)
                        && (empty($learningTrail->getNumEmp()) || $client->getNumEnterprise() == $learningTrail->getNumEmp())) {
                        array_push($learningTrails, $learningTrail);
                    }
                }
            }
            $entitiesLearningTrail = $learningTrails;
        }
        

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate($entitiesLearningTrail, $this->get('request')->query->get('page', 1), 20);

        return $this->render('AppBundle:Timeline:index.html.twig', array(
            'pagination' => $pagination,
            'client'=>$client
        ));
    }

    /**
     * @Route("/timeline/{id}", name="timeline_show")
     */
    public function timelineAction(Request $request, $id)
    {
        $this->validUser();
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $client = $this->getClient($user);

        $learningTrail = $em->getRepository('AppBundle:LearningTrail')->find($id);
        if (!$learningTrail) {
            throw new \Exception('Trilha de aprendizado não encontrada.');
        }

        if (!$user) {
            throw new \Exception('Você não tem acesso a esta página.');
        }

        $client = $em->getRepository('AppBundle:Client')->find($user->getId());
        // if(!$client){
        //     throw new \Exception('Você não tem acesso a esta página.');
        // }
        
        if ($client) {
            $repository = $em->getRepository('AppBundle:ClientLearningTrail');
            $clientLearningTrail = $repository->findOneBy(array(
                'client' => $client->getId(),
                'learningTrail' => $learningTrail->getId(),
            ));
    
            if (!$clientLearningTrail) {
                $clientLearningTrail = new ClientLearningTrail();
                $clientLearningTrail->setClient($client);
                $clientLearningTrail->setLearningTrail($learningTrail);
                $em->persist($clientLearningTrail);
                $em->flush();
            }
            $learningTrail = $clientLearningTrail->getLearningTrail();
            $courses = $clientLearningTrail->getLearningTrail()->getCourses();
        } else {
            $courses = $learningTrail->getCourses();
        }

        $trails = json_decode($courses, true);
        $readbleArray = $this->parseJsonArray($trails, $learningTrail);

        return $this->render('AppBundle:Timeline:timeline.html.twig', array(
            // 'trailData' => $trailsDataEntity,
            'readbleArray' => $readbleArray,
            'learningTrail' => $learningTrail,
            'client' => $client
        ));
    }

    public function parseJsonArray($jsonArray, $learningTrail, $lastTimelineStatus = 0, $index = 0)
    {
        $em = $this->getDoctrine()->getManager();
        $return = array();

        foreach ($jsonArray as $subArray) {
            $index++;
            $returnSubSubArray = array();
            $course = $em->getRepository('AppBundle:Course')->findOneBy(array('id' => $subArray['id']));
            $totalLessons = $this->getRepositoryFromBase('Course')->getTotalLessonCourse($course);
            $totalUserLessons = $this->getRepositoryFromBase('Course')->getTotalLessonUserCourse($this->getUser(), $course);

            $verifyInscription = $this->getRepositoryFromBase('Inscription')->verifyInscription($this->getUser(), $course);
            //Verifica se já está matriculado no curso ou se é auto inscrição
            if (!$course->isAccessAvailable($this->getUser()) && !$verifyInscription) {
                continue;
            }
            /*
            Timelinestatus - necessário para montagem correta da tela
            1 - Concluído
            2 - Proximo
            3 - Bloqueado
            */
            if ($learningTrail->getDependency()) {
                if ($lastTimelineStatus == 0) {
                    if ($totalUserLessons > 0 && $totalLessons == $totalUserLessons) {
                        $course->setTimelineStatus(1);
                        $lastTimelineStatus = 1;
                    } else {
                        $course->setTimelineStatus(2);
                        $lastTimelineStatus = 2;
                    }
                } elseif ($totalUserLessons > 0 && $totalLessons == $totalUserLessons) {
                    $course->setTimelineStatus(1);
                    $lastTimelineStatus = 1;
                } else {
                    if ($lastTimelineStatus == 1) {
                        $course->setTimelineStatus(2);
                        $lastTimelineStatus = 2;
                    } else {
                        $course->setTimelineStatus(3);
                        $lastTimelineStatus = 3;
                    }
                }
            } else {
                $course->setTimelineStatus(2);
            }
            if (isset($subArray['children'])) {
                $index++;
                $returnSubSubArray = $this->parseJsonArray($subArray['children'], $learningTrail, $lastTimelineStatus, $index);
            } else {
                $children = false;
            }

            $course->setTimelineChildren($returnSubSubArray);
            $course->setTimelineIndex($index);
            $return[] = array('course' => $course);
        }

        return $return;
    }

    public function parseJsonArrayId($jsonArray, $learningTrail, $index = 0)
    {
        $em = $this->getDoctrine()->getManager();
        $return = array();

        foreach ($jsonArray as $subArray) {
            $index++;
            $course = $em->getRepository('AppBundle:Course')->findOneBy(array('id' => $subArray['id']));
            $returnSubSubArray = array();
            if (isset($subArray['children'])) {
                $returnSubSubArray = $this->parseJsonArrayId($subArray['children'], $learningTrail, $index);
                array_merge($return, $returnSubSubArray);
            }
            if ($course) {
                array_push($return, $course->getId());
            }
        }
        return $return;
    }

    /**
     * @Route("/{id}/info-user/{type}", name="timeline_progressinfo")
     */
    public function showTrailInfoAction($id, $type="list")
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $learningTrail = $em->getRepository('AppBundle:LearningTrail')->find($id);

        $courses = $learningTrail->getCourses();
        $trails = json_decode($courses, true);
        $coursesArray = $this->parseJsonArrayId($trails, $learningTrail);
        $totalCourses = count($coursesArray);
        $percentualRealizadoTotal = 0;
        //Verifica se a trilha possui cursos disponíveis
        if ($totalCourses>0) {
            //Percorre os cursos da trilha
            foreach ($coursesArray as $id) {
                //Carrega o curso da iteração
                $course = $this->getRepositoryFromBase('Course')->find($id);
                //Busca a última matrícula do usuário para o curso
                $inscription = $this->getInscriptionRepository()->getLastInscriptionByUser($user, $course);
                //Busca as aulas assistidas pelo aluno no curso informado
                $totalUserLessons = $this->getRepositoryFromBase('Course')->getTotalLessonUserCourse($user, $course);
                $inscriptionLessons = $this->getInscriptionLessonRepository()->findAllByInscription($inscription, true);
                $totalLessonsConcluded = count($inscriptionLessons);
                //Verifica quantas aulas o curso possui
                if ($course->getTotalLessons() > 0) {
                    $percentualRealizado = ($totalUserLessons*100)/$course->getTotalLessons();
                    $percentualRealizadoTotal += round($percentualRealizado);
                }
            }
            //Divide o percentual total pela quantidade de cursos na trilha
            $percentualRealizadoTotal = $percentualRealizadoTotal/$totalCourses;
        }
        
        return $this->render('AppBundle:Timeline:show.progress.html.twig', array(
            'percentualRealizado' => $percentualRealizadoTotal,
            'type' => $type,
        ));
    }

    public function checkPropertyInCollection($entity, $collectionEntity)
    {
        if (!$collectionEntity || count($collectionEntity) == 0) {
            return true;
        }

        return ($entity && $entity->getId() && in_array($entity->getId(), $collectionEntity));
    }
}
