<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\Expose;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * AccessControl
 *
 * @ORM\Table(name="access_control")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\AccessControlRepository")
 */
class AccessControl
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="string", length=255)
     * @Expose
     */
    private $description;

    /**
     * @var integer
     *
     * @ORM\Column(name="permission", type="string", length=255, nullable=true)
     */
    private $permission;

    /**
     * @ORM\OneToMany(targetEntity="AccessPermissionControl", mappedBy="accessControl", cascade={"all"}, orphanRemoval=true)
     */
    protected $accessPermissions;

    /**
     * @ORM\OneToMany(targetEntity="EnterpriseAccessControl", mappedBy="accessControl", cascade={"all"}, orphanRemoval=true)
     */
    protected $enterprises;

    public function __toString()
    {
        return $this->description;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->accessPermissions = new \Doctrine\Common\Collections\ArrayCollection();
        $this->enterprises = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set description
     *
     * @param string $description
     *
     * @return AccessControl
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set permission
     *
     * @param string $permission
     *
     * @return AccessControl
     */
    public function setPermission($permission)
    {
        $this->permission = $permission;

        return $this;
    }

    /**
     * Get permission
     *
     * @return string
     */
    public function getPermission()
    {
        return $this->permission;
    }

    /**
     * Add accessPermission
     *
     * @param \AppBundle\Entity\AccessPermissionControl $accessPermission
     *
     * @return AccessControl
     */
    public function addAccessPermission(\AppBundle\Entity\AccessPermissionControl $accessPermission)
    {
        $accessPermission->setAccessControl($this);

        if ($accessPermission->getPermissionControl() instanceof \AppBundle\Entity\PermissionControl) {
            $this->accessPermissions->add($accessPermission);
        }

        return $this;
    }

    /**
     * Remove accessPermission
     *
     * @param \AppBundle\Entity\AccessPermissionControl $accessPermission
     */
    public function removeAccessPermission(\AppBundle\Entity\AccessPermissionControl $accessPermission)
    {
        $this->accessPermissions->removeElement($accessPermission);
    }

    /**
     * Set accessPermissions
     *
     * @param AccessPermissionControl $accessPermissions
     * @return AccessPermissionControl
     */
    public function setAccessPermissions($accessPermissions = null)
    {
        $this->accessPermissions = $accessPermissions;

        return $this;
    }

    /**
     * Get accessPermissions
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAccessPermissions()
    {
        return $this->accessPermissions;
    }

    /**
     * Add enterprise
     *
     * @param \AppBundle\Entity\EnterpriseAccessControl $enterprise
     *
     * @return AccessControl
     */
    public function addEnterprise(EnterpriseAccessControl $enterprise)
    {
        // $this->enterprises[] = $enterprise;
        $enterprise->setAccessControl($this);

        $this->enterprises->add($enterprise);
    }

    /**
     * Remove enterprise
     *
     * @param \AppBundle\Entity\EnterpriseAccessControl $enterprise
     */
    public function removeEnterprise(EnterpriseAccessControl $enterprise)
    {
        $this->enterprises->removeElement($enterprise);
    }

    /**
     * Set enqueteitems
     *
     * @param string $enqueteitems
     * @return AccessControl
     */
    public function setEnterprises($enterprises)
    {
        $this->enterprises = $enterprises;

        return $this;
    }

    /**
     * Get enterprises
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getEnterprises()
    {
        return $this->enterprises;
    }
}
