<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EnterpriseAccessControl
 *
 * @ORM\Table(name="access_permission_control")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\EnterpriseAccessControlRepository")
 */
class AccessPermissionControl
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var AccessControl
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\AccessControl")
     * @ORM\JoinColumn(name="access_control_id", referencedColumnName="id", nullable=true, onDelete="SET NULL")
     */
    private $accessControl;

    /**
     * @var PermissionControl
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\PermissionControl")
     * @ORM\JoinColumn(name="permission_control_id", referencedColumnName="id", nullable=true, onDelete="SET NULL")
     */
    private $permissionControl;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    public function __toString()
    {
        return $this->id;
    }

    /**
     * Set accessControl
     *
     * @param \AppBundle\Entity\AccessControl $accessControl
     *
     * @return AccessPermissionControl
     */
    public function setAccessControl(\AppBundle\Entity\AccessControl $accessControl = null)
    {
        $this->accessControl = $accessControl;

        return $this;
    }

    /**
     * Get accessControl
     *
     * @return \AppBundle\Entity\AccessControl
     */
    public function getAccessControl()
    {
        return $this->accessControl;
    }

    /**
     * Set permissionControl
     *
     * @param \AppBundle\Entity\PermissionControl $permissionControl
     *
     * @return AccessPermissionControl
     */
    public function setPermissionControl(\AppBundle\Entity\PermissionControl $permissionControl = null)
    {
        $this->permissionControl = $permissionControl;

        return $this;
    }

    /**
     * Get permissionControl
     *
     * @return \AppBundle\Entity\PermissionControl
     */
    public function getPermissionControl()
    {
        return $this->permissionControl;
    }
}
