<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Class
 *
 * @ORM\Table(name="answer")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\AnswerRepository")
 */
class Answer
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var UserEvaluation
     *
     * @ORM\ManyToOne(targetEntity="UserEvaluation")
     * @ORM\JoinColumn(name="user_evaluation_id", referencedColumnName="id", nullable=true)
     */
    private $userEvaluation;

    /**
     * @var Question
     *
     * @ORM\ManyToOne(targetEntity="Question")
     * @ORM\JoinColumn(name="question_id", referencedColumnName="id", nullable=true)
     */
    private $question;

    /**
     * @var QuestionItem
     *
     * @ORM\ManyToOne(targetEntity="QuestionItem")
     * @ORM\JoinColumn(name="questionitem_id", referencedColumnName="id", nullable=true)
     */
    private $questionItem;

    /**
     * @var string
     *
     * @ORM\Column(name="correct_answer", type="boolean")
     */
    private $correctAnswer;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_creation", type="datetime")
     * @Gedmo\Timestampable(on="create")
     */
    private $dtCreation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_update", type="datetime")
     * @Gedmo\Timestampable(on="update")
     */
    private $dtUpdate;

    public function __toString()
    {
        return $this->id;
    }

    /**
     * Set id
     *
     * @param integer $id;
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set userEvaluation
     *
     * @param UserEvaluation $userEvaluation
     * @return Answer
     */
    public function setUserEvaluation($userEvaluation = null)
    {
        $this->userEvaluation = $userEvaluation;

        return $this;
    }

    /**
     * Get userEvaluation
     *
     * @return Answer
     */
    public function getUserEvaluation()
    {
        return $this->userEvaluation;
    }

    /**
     * Set question
     *
     * @param string $description
     * @return Answer
     */
    public function setQuestion($question)
    {
        $this->question = $question;

        return $this;
    }

    /**
     * Get question
     *
     * @return string
     */
    public function getQuestion()
    {
        return $this->question;
    }

    /**
     * Set questionItem
     *
     * @param QuestionItem $questionItem
     * @return Answer
     */
    public function setQuestionItem($questionItem)
    {
        $this->questionItem = $questionItem;

        return $this;
    }

    /**
     * Get questionItem
     *
     * @return QuestionItem
     */
    public function getQuestionItem()
    {
        return $this->questionItem;
    }

    /**
     * Set correctAnswer
     *
     * @param boolean $correctAnswer
     * @return Answer
     */
    public function setCorrectAnswer($correctAnswer)
    {
        $this->correctAnswer = $correctAnswer;

        return $this;
    }

    /**
     * Get correctAnswer
     *
     * @return boolean
     */
    public function getCorrectAnswer()
    {
        return $this->correctAnswer;
    }

    /**
     * Set dtCreation
     *
     * @param \DateTime $dtCreation
     *
     * @return Payment
     */
    public function setDtCreation($dtCreation)
    {
        $this->dtCreation = $dtCreation;

        return $this;
    }

    /**
     * Get dtCreation
     *
     * @return \DateTime
     */
    public function getDtCreation()
    {
        return $this->dtCreation;
    }

    /**
     * Set dtUpdate
     *
     * @param \DateTime $dtUpdate
     *
     * @return Payment
     */
    public function setDtUpdate($dtUpdate)
    {
        $this->dtUpdate = $dtUpdate;

        return $this;
    }

    /**
     * Get dtUpdate
     *
     * @return \DateTime
     */
    public function getDtUpdate()
    {
        return $this->dtUpdate;
    }
}
