<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Type;

/**
 * BannerFilter
 *
 * @ORM\Table(name="banner_filter")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\BannerRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class BannerFilter
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * One Cart has One Customer.
     * @ORM\OneToOne(targetEntity="Banner", inversedBy="bannerFilter")
     * @ORM\JoinColumn(name="banner_id", referencedColumnName="id", onDelete="CASCADE")
     */
    private $banner;

    /**
     * @var string
     *
     * @ORM\Column(name="sectors", type="text", nullable=true)
     * @Expose
     */
    private $sectors;

    /**
     * @var string
     *
     * @ORM\Column(name="job_roles", type="text", nullable=true)
     * @Expose
     */
    private $jobRoles;

    /**
     * @var string
     *
     * @ORM\Column(name="managements", type="text", nullable=true)
     * @Expose
     */
    private $managements;

    public function __toString()
    {
        return $this->id;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set sectors
     *
     * @param string $sectors
     *
     * @return BannerFilter
     */
    public function setSectors($sectors)
    {
        $this->sectors = $sectors;

        return $this;
    }

    /**
     * Get sectors
     *
     * @return string
     */
    public function getSectors()
    {
        return json_decode($this->sectors);
    }

    /**
     * Set jobRoles
     *
     * @param string $jobRoles
     *
     * @return BannerFilter
     */
    public function setJobRoles($jobRoles)
    {
        $this->jobRoles = $jobRoles;

        return $this;
    }

    /**
     * Get jobRoles
     *
     * @return string
     */
    public function getJobRoles()
    {
        return json_decode($this->jobRoles);
    }

    /**
     * Set managements
     *
     * @param string $managements
     *
     * @return BannerFilter
     */
    public function setManagements($managements)
    {
        $this->managements = $managements;

        return $this;
    }

    /**
     * Get managements
     *
     * @return string
     */
    public function getManagements()
    {
        return json_decode($this->managements);
    }

    /**
     * Set banner
     *
     * @param \AppBundle\Entity\Banner $banner
     *
     * @return BannerFilter
     */
    public function setBanner(\AppBundle\Entity\Banner $banner = null)
    {
        $this->banner = $banner;

        return $this;
    }

    /**
     * Get banner
     *
     * @return \AppBundle\Entity\Banner
     */
    public function getBanner()
    {
        return $this->banner;
    }
}
