<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Type;
use AppBundle\Service\StringService;

/**
 * Class
 *
 * @ORM\Table(name="category")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\CategoryRepository")
 * @ExclusionPolicy("all")
 */
class Category
{
    const MODALITY_PRESENCIAL = "Presencial";
    const MODALITY_EAD = "EAD";

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Expose
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     * @Expose
     */
    private $name;

    /**
     * @var int
     *
     * @ORM\Column(name="modality", type="string", length=255, nullable=true)
     */
    private $modality;

    /**
     * __toString method
     */
    public function __toString() {
        return $this->getName();
    }

    /**
     * Set id
     *
     * @param integer $id;
     */
    public function setId($id) {
        $this->id = $id;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Evaluation
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    public function isSecretaria()
    {
        $category = StringService::stripAccents($this->name);
        // return strripos("SECRETÁRIA", $this->name);
        $isSecretaria = strripos($category, "secretaria");
        return $isSecretaria ===  false ? false : true;
    }

    /**
     *
     * @return integer
     */
    public function getModality()
    {
        return $this->modality;
    }

    /**
     *
     */
    public function setModality($modality)
    {
        $this->modality = $modality;
    }
}
