<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use UserBundle\Entity\User;

/**
 * Client
 *
 * @ORM\Table(name="client")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\ClientRepository")
 */
class Client extends User
{
    public function __construct()
    {
        parent::__construct();
        $this->clientLearningTrail = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * @var int
     * Campo referente ao parâmetro codLMS
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var string
     *
     * @ORM\Column(name="num_enterprise", type="integer", nullable=true)
     */
    protected $num_enterprise;

    /**
     * @var string
     *
     * @ORM\Column(name="num_local", type="string", nullable=true)
     */
    protected $numLocal;

    /**
     * @var string
     *
     * @ORM\Column(name="tip_colaborador", type="integer", nullable=true)
     */
    protected $tip_colaborador;

    /**
     * @var string
     *
     * @ORM\Column(name="mat_colaborador", type="integer", nullable=true)
     */
    protected $mat_colaborador;

    /**
     * @var string
     *
     * @ORM\Column(name="cod_pessoa", type="string", nullable=true)
     */
    protected $codPes;

    /**
     * @var string
     *
     * @ORM\Column(name="matricula", type="string", nullable=true)
     */
    protected $matricula;

    /**
     * @var string
     *
     * @ORM\Column(name="sit_colaborador", type="integer", nullable=true)
     */
    protected $sitCua;

    /**
     * @ORM\OneToMany(targetEntity="ClientLearningTrail", mappedBy="client", cascade={"all"}, orphanRemoval=true)
     */
    private $clientLearningTrail;

    /**
     * @var string
     *
     * @ORM\Column(name="cpf", type="string", nullable=true)
     */
    protected $cpf;

    /**
     * @var string
     *
     * @ORM\Column(name="login", type="string", nullable=true)
     */
    protected $login;

    /**
     * @var string
     *
     * @ORM\Column(name="groupUser", type="string", nullable=true)
     */
    protected $group;

    /**
     * Set codEvn
     *
     * @param integer $codEvn
     *
     * @return Client
     */
    public function setCodEvn($codEvn)
    {
        $this->codEvn = $codEvn;

        return $this;
    }

    /**
     * Get codEvn
     *
     * @return integer
     */
    public function getCodEvn()
    {
        return $this->codEvn;
    }

    /**
     * Set num_enterprise
     *
     * @param integer $num_enterprise
     *
     * @return Client
     */
    public function setNumEnterprise($num_enterprise)
    {
        $this->num_enterprise = $num_enterprise;

        return $this;
    }

    /**
     * Get num_enterprise
     *
     * @return integer
     */
    public function getNumEnterprise()
    {
        return $this->num_enterprise;
    }

    /**
     * Set numLocal
     *
     * @param integer $numLocal
     *
     * @return Client
     */
    public function setNumLocal($numLocal)
    {
        $this->numLocal = $numLocal;

        return $this;
    }

    /**
     * Get numLocal
     *
     * @return integer
     */
    public function getNumLocal()
    {
        return $this->numLocal;
    }

    /**
     * Set tip_colaborador
     *
     * @param integer $tip_colaborador
     *
     * @return Client
     */
    public function setTipColaborador($tip_colaborador)
    {
        $this->tip_colaborador = $tip_colaborador;

        return $this;
    }

    /**
     * Get tip_colaborador
     *
     * @return integer
     */
    public function getTipColaborador()
    {
        return $this->tip_colaborador;
    }

    /**
     * Set mat_colaborador
     *
     * @param integer $mat_colaborador
     *
     * @return Client
     */
    public function setMatColaborador($mat_colaborador)
    {
        $this->mat_colaborador = $mat_colaborador;

        return $this;
    }

    /**
     * Get mat_colaborador
     *
     * @return integer
     */
    public function getMatColaborador()
    {
        return $this->mat_colaborador;
    }

    /**
     * Set matricula
     *
     * @param integer $matricula
     *
     * @return Client
     */
    public function setMatricula($matricula)
    {
        $this->matricula = $matricula;

        return $this;
    }

    /**
     * Get matricula
     *
     * @return integer
     */
    public function getMatricula()
    {
        return $this->matricula;
    }

    /**
     * Set codPes
     *
     * @param integer $codPes
     *
     * @return Client
     */
    public function setCodPes($codPes)
    {
        $this->codPes = $codPes;

        return $this;
    }

    /**
     * Get codPes
     *
     * @return integer
     */
    public function getCodPes()
    {
        return $this->codPes;
    }

    /**
     * Set sitCua
     *
     * @param integer $sitCua
     *
     * @return Client
     */
    public function setSitCua($sitCua)
    {
        $this->sitCua = $sitCua;

        return $this;
    }

    /**
     * Get sitCua
     *
     * @return integer
     */
    public function getSitCua()
    {
        return $this->sitCua;
    }

    /**
     * Set cpf
     *
     * @param integer $cpf
     *
     * @return Client
     */
    public function setCpf($cpf)
    {
        $this->cpf = $cpf;

        return $this;
    }

    /**
     * Get cpf
     *
     * @return integer
     */
    public function getCpf()
    {
        return $this->cpf;
    }

    /**
     * Set login
     *
     * @param integer $login
     *
     * @return Client
     */
    public function setLogin($login)
    {
        $this->login = $login;

        return $this;
    }

    /**
     * Get login
     *
     * @return integer
     */
    public function getLogin()
    {
        return $this->login;
    }

    /**
     * Set group
     *
     * @param integer $group
     *
     * @return Client
     */
    public function setGroup($group)
    {
        $this->group = $group;

        return $this;
    }

    /**
     * Get group
     *
     * @return integer
     */
    public function getGroup()
    {
        return $this->group;
    }

    /**
     * Add inscription
     *
     * @param \AppBundle\Entity\Inscription $inscription
     *
     * @return Client
     */
    public function addInscription(\AppBundle\Entity\Inscription $inscription)
    {
        $this->inscriptions[] = $inscription;

        return $this;
    }

    /**
     * Remove inscription
     *
     * @param \AppBundle\Entity\Inscription $inscription
     */
    public function removeInscription(\AppBundle\Entity\Inscription $inscription)
    {
        $this->inscriptions->removeElement($inscription);
    }

    /**
     * Add clientLearningTrail
     *
     * @param \AppBundle\Entity\ClientLearningTrail $clientLearningTrail
     *
     * @return Videos
     */
    public function addClientLearningTrail(ClientLearningTrail $clientLearningTrail)
    {
        $clientLearningTrail->setClient($this);

        $this->clientLearningTrail->add($clientLearningTrail);
    }

    /**
     * Remove ClientLearningTrail
     *
     * @param \AppBundle\Entity\ClientLearningTrail $clientLearningTrail
     */
    public function removeClientLearningTrail(\AppBundle\Entity\ClientLearningTrail $clientLearningTrail)
    {
        $this->clientLearningTrail->removeElement($clientLearningTrail);
    }

    /**
     * Set ClientLearningTrail
     *
     * @param ClientLearningTrail $clientLearningTrail
     * @return ClientLearningTrail
     */
    public function setClientLearningTrail($clientLearningTrail = null)
    {
        $this->clientLearningTrail = $clientLearningTrail;

        return $this;
    }

    /**
     * Get ClientLearningTrail
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getClientLearningTrail()
    {
        return $this->clientLearningTrail;
    }

    public function getCpfOnlyNumbers()
    {
        $cpf = str_replace(".", "", $this->cpf);
        $cpf = str_replace("-", "", $cpf);
        return $cpf;
    }

    public function getCrmForMediacenter()
    {
        $login = strtoupper($this->getLogin());
        $crm = '';

        $validUidTypeAdm = preg_match("/^ADM00611/", $login);
        $validUidTypeCrm = preg_match("/^CRM/", $login);

        if ($validUidTypeAdm) {
            $crm = str_replace("ADM00611", "", $login);
            $crm = substr_replace($crm, "", -1);
        } elseif ($validUidTypeCrm) {
            $crm = str_replace("CRM", "", $login);
        }else{
            $crm = $this->getLogin();
        }

        return $crm;
    }
}
