<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * ClientLearningTrail
 *
 * @ORM\Table(name="client_learningtrail")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\ClientLearningTrailRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class ClientLearningTrail
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var LearningTrail
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\LearningTrail")
     * @ORM\JoinColumn(name="learningtrail_id", referencedColumnName="id")
     */
    private $learningTrail;

    /**
     * @var Video
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Client")
     * @ORM\JoinColumn(name="client_id", referencedColumnName="id", nullable=true)
     */
    private $client;

    public function __toString()
    {
        return $this->id;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set learningTrail
     *
     * @param \AppBundle\Entity\ClientLearningTrail $learningTrail
     *
     * @return ClientLearningTrail
     */
    public function setLearningTrail(\AppBundle\Entity\LearningTrail $learningTrail = null)
    {
        $this->learningTrail = $learningTrail;

        return $this;
    }

    /**
     * Get learningTrail
     *
     * @return \AppBundle\Entity\Category
     */
    public function getLearningTrail()
    {
        return $this->learningTrail;
    }

    /**
     * Set client
     *
     * @param \AppBundle\Entity\Client $client
     *
     * @return ClientLearningTrail
     */
    public function setClient(\AppBundle\Entity\Client $client = null)
    {
        $this->client = $client;

        return $this;
    }

    /**
     * Get client
     *
     * @return \AppBundle\Entity\Client
     */
    public function getClient()
    {
        return $this->client;
    }
}
