<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Configuration
 *
 * @ORM\Table(name="configuration")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\ConfigurationRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class Configuration
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_creation", type="datetime", nullable=true)
     * @Gedmo\Timestampable(on="create")
     */
    private $dtCreation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_update", type="datetime", nullable=true)
     * @Gedmo\Timestampable(on="update")
     */
    private $dtUpdate;

    /**
     * @var string
     *
     * @ORM\Column(name="certificate_front", type="string", length=255, nullable=true)
     */
    private $certificateFront;

    /**
     * @var string
     *
     * @ORM\Column(name="certificate_back", type="string", length=255, nullable=true)
     */
    private $certificateBack;

    /**
     * @var string
     *
     * @ORM\Column(name="signature", type="string", length=255, nullable=true)
     */
    private $signature;

    /**
     * Upload banner
     */
    const UPLOAD_PATH_IMAGE = 'uploads/configuration/';

    /**
     * @Assert\File(
     *     maxSize = "1536k",
     *     maxSizeMessage = "O tamanho do arquivo é muito grande ({{ size }} {{ suffix }}), escolha um arquivo de até {{ limit }} {{ suffix }}",
     *     mimeTypes = {"image/jpeg", "image/gif", "image/png"},
     *     mimeTypesMessage = "Formato de arquivo inválido. Formatos permitidos: .gif, .jpeg e .png"
     * )
     */
    private $certificateFrontTemp;

    /**
     * @Assert\File(
     *     maxSize = "1536k",
     *     maxSizeMessage = "O tamanho do arquivo é muito grande ({{ size }} {{ suffix }}), escolha um arquivo de até {{ limit }} {{ suffix }}",
     *     mimeTypes = {"image/jpeg", "image/gif", "image/png"},
     *     mimeTypesMessage = "Formato de arquivo inválido. Formatos permitidos: .gif, .jpeg e .png"
     * )
     */
    private $certificateBackTemp;

    /**
     * @Assert\File(
     *     maxSize = "1536k",
     *     maxSizeMessage = "O tamanho do arquivo é muito grande ({{ size }} {{ suffix }}), escolha um arquivo de até {{ limit }} {{ suffix }}",
     *     mimeTypes = {"image/jpeg", "image/gif", "image/png"},
     *     mimeTypesMessage = "Formato de arquivo inválido. Formatos permitidos: .gif, .jpeg e .png"
     * )
     */
    private $signatureTemp;

    /**
     * Sets certificateFrontTemp
     *
     * @param UploadedFile $certificateFrontTemp
     */
    public function setCertificateFrontTemp(UploadedFile $certificateFrontTemp = null)
    {
        $this->certificateFrontTemp = $certificateFrontTemp;
    }

    /**
     * Get certificateFrontTemp
     *
     * @return UploadedFile
     */
    public function getCertificateFrontTemp()
    {
        return $this->certificateFrontTemp;
    }

    /**
     * Sets certificateBackTemp
     *
     * @param UploadedFile $certificateBackTemp
     */
    public function setCertificateBackTemp(UploadedFile $certificateBackTemp = null)
    {
        $this->certificateBackTemp = $certificateBackTemp;
    }

    /**
     * Get certificateBackTemp
     *
     * @return UploadedFile
     */
    public function getCertificateBackTemp()
    {
        return $this->certificateBackTemp;
    }

    /**
     * Sets signatureTemp
     *
     * @param UploadedFile $signatureTemp
     */
    public function setSignatureTemp(UploadedFile $signatureTemp = null)
    {
        $this->signatureTemp = $signatureTemp;
    }

    /**
     * Get signatureTemp
     *
     * @return UploadedFile
     */
    public function getSignatureTemp()
    {
        return $this->signatureTemp;
    }

    /**
     * Unlink File
     */
    public function unlinkFiles()
    {
        if ($this->getCertificateFront() != null) {
            unlink(Configuration::UPLOAD_PATH_IMAGE ."/". $this->getCertificateFront());
        }

        if ($this->getCertificateBack() != null) {
            unlink(Configuration::UPLOAD_PATH_IMAGE ."/". $this->getCertificateBack());
        }

        if ($this->getSignature() != null) {
            unlink(Configuration::UPLOAD_PATH_IMAGE ."/". $this->getSignature());
        }
    }

    /**
     * Manages the copying of the file to the relevant place on the server
     */
    public function uploadFile()
    {

        //Upload de image
        if ($this->getCertificateFrontTemp()!=null) {
            //Se o diretorio não existir, cria
            if (!file_exists(Configuration::UPLOAD_PATH_IMAGE)) {
                mkdir(Configuration::UPLOAD_PATH_IMAGE, 0755, true);
            }
            if (($this->getCertificateFrontTemp() != $this->getCertificateFront())
                && (null !== $this->getCertificateFront())
            ) {
                unlink(Configuration::UPLOAD_PATH_IMAGE ."/". $this->getCertificateFront());
            }

            // Generate a unique name for the file before saving it
            $fileName = md5(uniqid()).'.'.$this->getCertificateFrontTemp()->guessExtension();

            UploadService::upload($this->getCertificateFrontTemp(), Configuration::UPLOAD_PATH_IMAGE."/".$fileName);

            // set the path property to the filename where you've saved the file
            $this->certificateFront = $fileName;

            // clean up the file property as you won't need it anymore
            $this->setCertificateFrontTemp(null);
        }

        //Upload de image
        if ($this->getCertificateBackTemp()!=null) {
            //Se o diretorio não existir, cria
            if (!file_exists(Configuration::UPLOAD_PATH_IMAGE)) {
                mkdir(Configuration::UPLOAD_PATH_IMAGE, 0755, true);
            }
            if (($this->getCertificateBackTemp() != $this->getCertificateBack())
                && (null !== $this->getCertificateBack())
            ) {
                unlink(Configuration::UPLOAD_PATH_IMAGE ."/". $this->getCertificateBack());
            }

            // Generate a unique name for the file before saving it
            $fileName = md5(uniqid()).'.'.$this->getCertificateBackTemp()->guessExtension();

            UploadService::upload($this->getCertificateBackTemp(), Configuration::UPLOAD_PATH_IMAGE."/".$fileName);

            // set the path property to the filename where you've saved the file
            $this->certificateBack = $fileName;

            // clean up the file property as you won't need it anymore
            $this->setCertificateBackTemp(null);
        }

        //Upload de image
        if ($this->getSignatureTemp()!=null) {
            //Se o diretorio não existir, cria
            if (!file_exists(Configuration::UPLOAD_PATH_IMAGE)) {
                mkdir(Configuration::UPLOAD_PATH_IMAGE, 0755, true);
            }
            if (($this->getSignatureTemp() != $this->getSignature())
                && (null !== $this->getSignature())
            ) {
                unlink(Configuration::UPLOAD_PATH_IMAGE ."/". $this->getSignature());
            }

            // Generate a unique name for the file before saving it
            $fileName = md5(uniqid()).'.'.$this->getSignatureTemp()->guessExtension();

            UploadService::upload($this->getSignatureTemp(), Configuration::UPLOAD_PATH_IMAGE."/".$fileName);

            // set the path property to the filename where you've saved the file
            $this->signature = $fileName;

            // clean up the file property as you won't need it anymore
            $this->setSignatureTemp(null);
        }
    }

    /**
     * Lifecycle callback to upload the file to the server
     * @ORM\PrePersist
     * @ORM\PreUpdate
     */
    public function lifecycleFileUpload()
    {
        $this->uploadFile();
    }

    /**
     * @ORM\PostLoad()
     */
    public function postLoad()
    {
        $this->dtUpdate = new \DateTime();
    }

    public function __toString()
    {
        return $this->name;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set dtCreation
     *
     * @param \DateTime $dtCreation
     *
     * @return Configuration
     */
    public function setDtCreation($dtCreation)
    {
        $this->dtCreation = $dtCreation;

        return $this;
    }

    /**
     * Get dtCreation
     *
     * @return \DateTime
     */
    public function getDtCreation()
    {
        return $this->dtCreation;
    }

    /**
     * Set dtUpdate
     *
     * @param \DateTime $dtUpdate
     *
     * @return Configuration
     */
    public function setDtUpdate($dtUpdate)
    {
        $this->dtUpdate = $dtUpdate;

        return $this;
    }

    /**
     * Get dtUpdate
     *
     * @return \DateTime
     */
    public function getDtUpdate()
    {
        return $this->dtUpdate;
    }

    /**
     * Set certificateFront
     *
     * @param string $certificateFront
     *
     * @return Configuration
     */
    public function setCertificateFront($certificateFront)
    {
        $this->certificateFront = $certificateFront;

        return $this;
    }

    /**
     * Get certificateFront
     *
     * @return string
     */
    public function getCertificateFront()
    {
        return $this->certificateFront;
    }

    /**
     * Set certificateBack
     *
     * @param string $certificateBack
     *
     * @return Configuration
     */
    public function setCertificateBack($certificateBack)
    {
        $this->certificateBack = $certificateBack;

        return $this;
    }

    /**
     * Get certificateBack
     *
     * @return string
     */
    public function getCertificateBack()
    {
        return $this->certificateBack;
    }

    /**
     * Set signature
     *
     * @param string $signature
     *
     * @return Configuration
     */
    public function setSignature($signature)
    {
        $this->signature = $signature;

        return $this;
    }

    /**
     * Get signature
     *
     * @return string
     */
    public function getSignature()
    {
        return $this->signature;
    }

    
}
