<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Type;

/**
 * Course
 *
 * @ORM\Table(name="course")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\CourseRepository")
 * @ORM\HasLifecycleCallbacks()
 * @ExclusionPolicy("all")
 */
class Course
{
    const MODALITY_PRESENCIAL = "Presencial";
    const MODALITY_EAD = "EAD";
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Expose
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     * @Expose
     */
    private $name;


    /**
     * @var string
     *
     * @ORM\Column(name="title", type="string", length=255, nullable=true)
     * @Expose
     */
    private $title;

    /**
     * @var string
     *
     * @ORM\Column(name="codeevent", type="string", length=255, nullable=true)
     */
    private $codeevent;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="text", nullable=true)
     * @Expose
     */
    private $description;

    /**
     * @var string
     *
     * @ORM\Column(name="short_description", type="text", nullable=true)
     */
    private $short_description;

    /**
     * @var string
     *
     * @ORM\Column(name="scorm_file", type="text", nullable=true)
     * @Expose
     */
    private $scormFile;

    /**
     * @var string
     *
     * @ORM\Column(name="cover", type="string", length=255, nullable=true)
     */
    private $cover;

    /**
     * @var string
     *
     * @ORM\Column(name="certificate", type="string", length=255, nullable=true)
     */
    private $certificate;

    /**
     * @var string
     *
     * @ORM\Column(name="certificate_back", type="string", length=255, nullable=true)
     */
    private $certificate_back;

    /**
     * @ORM\OneToMany(targetEntity="Module", mappedBy="course", cascade={"all"})
     */
    protected $modules;

    /**
     * @ORM\OneToMany(targetEntity="Inscription", mappedBy="course", cascade={"all"})
     */
    protected $inscriptions;

    /**
     * @ORM\OneToMany(targetEntity="CourseFeedback", mappedBy="course", cascade={"all"})
     */
    protected $feedbacks;

    /**
     * @ORM\OneToMany(targetEntity="SurveyAnswer", mappedBy="course", cascade={"all"})
     */
    protected $surveyanswers;

    /**
     * @var integer
     *
     * @ORM\Column(name="disponible_days", type="integer", nullable=true)
     */
    private $disponibleDays;

    /**
     * @var integer
     *
     * @ORM\Column(name="pontuation", type="integer", nullable=true)
     */
    private $pontuation;

    /**
     * @var integer
     *
     * @ORM\Column(name="cod_curso", type="integer", nullable=true)
     */
    private $codcurso;

    /**
     * @var integer
     *
     * @ORM\Column(name="operador", type="string", length=255, nullable=true)
     */
    private $operador;

    /**
    * @var string
    *
    * @ORM\Column(name="id_event", type="string", length=255, nullable=true)
    */
    private $idevent;

    /**
     * @var integer
     *
     * @ORM\Column(name="quantvagas", type="integer", nullable=true)
     */
    private $quantvagas;

    /**
     * @var string
     *
     * @ORM\Column(name="slug", type="string", length=255)
     * @Gedmo\Slug(fields={"name"})
     */
    private $slug;

    /**
     * @var string
     *
     * @ORM\Column(name="id_media_degustacao", type="string", length=255, nullable=true)
     */
    private $idMediaDegustacao;

    /**
     * @var string
     *
     * @ORM\Column(name="nota_media", type="decimal", precision=10, scale=2, nullable=true)
     */
    private $notaMedia;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_initial", type="datetime", nullable=true)
     */
    private $dtInitial;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_end", type="datetime", nullable=true)
     */
    private $dtEnd;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_inscription_begin", type="datetime", nullable=true)
     */
    private $dtInscriptionBegin;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_inscription_end", type="datetime", nullable=true)
     */
    private $dtInscriptionEnd;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_cancel", type="datetime", nullable=true)
     */
    private $dtCancel;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_creation", type="datetime")
     * @Gedmo\Timestampable(on="create")
     */
    private $dtCreation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_update", type="datetime")
     * @Gedmo\Timestampable(on="update")
     */
    private $dtUpdate;

    /**
     * @var string
     *
     * @ORM\Column(name="nameevent", type="string", length=255, nullable=true)
     */
    private $nameevent;

    /**
     * @var string
     *
     * @ORM\Column(name="autor", type="string", length=255, nullable=true)
     */
    private $autor;

    /**
     * @var string
     *
     * @ORM\Column(name="type", type="string", length=255, nullable=true)
     */
    private $type;

    /**
     * @var string
     *
     * @ORM\Column(name="situacao", type="string", length=255, nullable=true)
     */
    private $situacao;

    /**
     * @var int
     *
     * @ORM\Column(name="duracao_curso", type="string", length=255, nullable=true)
     */
    private $duracaoCurso;

    /**
     * @var int
     *
     * @ORM\Column(name="modality", type="string", length=255, nullable=true)
     */
    private $modality = 'EAD';

    /**
     * @var Category
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Category")
     * @ORM\JoinColumn(name="category_id", referencedColumnName="id", nullable=true, onDelete="SET NULL")
     */
    private $category;

    /**
     * @var Survey
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Survey")
     * @ORM\JoinColumn(name="survey_id", referencedColumnName="id", nullable=true, onDelete="SET NULL")
     */
    private $survey;

    /**
     * @var string
     *
     * @ORM\Column(name="typecourse", type="string", length=255, nullable=true)
     */
    private $typecourse;

    /**
     * @var string
     *
     * @ORM\Column(name="active", type="boolean")
     */
    private $active;

    /**
     * @var string
     *
     * @ORM\Column(name="auto_inscription", type="boolean", nullable=true)
     */
    private $autoInscription;

    /**
     * @var string
     *
     * @ORM\Column(name="module_dependency", type="boolean", nullable=true)
     */
    private $moduleDependency;

    /**
     * @var int
     *
     * @ORM\Column(name="link_trail_external", type="string", length=500, nullable=true)
     */
    private $linkTrailExternal;

    /**
     * @var string
     *
     * @ORM\Column(name="conclusion_link", type="string", length=255, nullable=true)
     */
    private $conclusionLink;

    /**
     * @ORM\OneToMany(targetEntity="CourseAccessControl", mappedBy="course", cascade={"all"}, orphanRemoval=true)
     */
    protected $courseAccessControls;

    /**
     * @var integer
     *
     * @ORM\Column(name="salutaris_id", type="integer", length=25, nullable=true)
     */
    private $salutarisId;

    public function __construct()
    {
        $this->lessons = new ArrayCollection();
        $this->inscriptions = new ArrayCollection();
        $this->feedbacks = new ArrayCollection();
        $this->surveyanswers = new ArrayCollection();
        $this->courseAccessControls = new ArrayCollection();
    }

    public function __toString()
    {
        return $this->name;
    }

    /**
     * Set id
     *
     * @param integer $id;
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Course
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set title
     *
     * @param string $title
     * @return Course
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set typecourse
     *
     * @param string $typecourse
     * @return Course
     */
    public function setTypeCourse($typecourse)
    {
        $this->typecourse = $typecourse;

        return $this;
    }

    /**
     * Get typecourse
     *
     * @return string
     */
    public function getTypeCourse()
    {
        return $this->typecourse;
    }

    /**
     * Set codeevent
     *
     * @param string $codeevent
     * @return Course
     */
    public function setCodeevent($codeevent)
    {
        $this->codeevent = $codeevent;

        return $this;
    }

    /**
     * Get codeevent
     *
     * @return string
     */
    public function getCodeevent()
    {
        return $this->codeevent;
    }

    /**
     * Set idevent
     *
     * @param string $idevent
     * @return Course
     */
    public function setIdevent($idevent)
    {
        $this->idevent = $idevent;

        return $this;
    }

    /**
     * Get idevent
     *
     * @return string
     */
    public function getIdevent()
    {
        return $this->idevent;
    }

    /**
     * Set situacao
     *
     * @param string $situacao
     * @return Course
     */
    public function setSituacao($situacao)
    {
        $this->situacao = $situacao;

        return $this;
    }

    /**
     * Get situacao
     *
     * @return string
     */
    public function getSituacao()
    {
        return $this->situacao;
    }

    /**
     * Set type
     *
     * @param string $type
     * @return Course
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }


    /**
     * Set nameevent
     *
     * @param string $nameevent
     * @return Course
     */
    public function setNameevent($nameevent)
    {
        $this->nameevent = $nameevent;

        return $this;
    }

    /**
     * Get nameevent
     *
     * @return string
     */
    public function getNameevent()
    {
        return $this->nameevent;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return Course
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set short_description
     *
     * @param string $short_description
     * @return Course
     */
    public function setShortDescription($short_description)
    {
        $this->short_description = $short_description;

        return $this;
    }

    /**
     * Get short_description
     *
     * @return string
     */
    public function getShortDescription()
    {
        return $this->short_description;
    }

    /**
     * Set scormFile
     *
     * @param string $scormFile
     * @return Course
     */
    public function setScormFile($scormFile)
    {
        $this->scormFile = $scormFile;

        return $this;
    }

    /**
     * Get scormFile
     *
     * @return string
     */
    public function getScormFile()
    {
        return $this->scormFile;
    }

    /**
     * Set cover
     *
     * @param string $cover
     *
     * @return Course
     */
    public function setCover($cover)
    {
        $this->cover = $cover;

        return $this;
    }

    /**
     * Get cover
     *
     * @return string
     */
    public function getCover()
    {
        return $this->cover;
    }

    /**
     * Set certificate
     *
     * @param string $certificate
     *
     * @return Course
     */
    public function setCertificate($certificate)
    {
        $this->certificate = $certificate;

        return $this;
    }

    /**
     * Get certificate
     *
     * @return string
     */
    public function getCertificate()
    {
        return $this->certificate;
    }

    /**
     * Set certificate_back
     *
     * @param string $certificate_back
     *
     * @return Course
     */
    public function setCertificateBack($certificate_back)
    {
        $this->certificate_back = $certificate_back;

        return $this;
    }

    /**
     * Get certificate_back
     *
     * @return string
     */
    public function getCertificateBack()
    {
        return $this->certificate_back;
    }

    /**
     *
     * @return type
     */
    public function getModules()
    {
        return $this->modules;
    }

    /**
     *
     */
    public function setModules($modules)
    {
        $this->modules = $modules;
    }

    /**
     *
     * @return type
     */
    public function getInscriptions()
    {
        return $this->inscriptions;
    }

    /**
     *
     */
    public function setInscriptions($inscriptions)
    {
        $this->inscriptions = $inscriptions;
    }

    /**
     *
     * @return type
     */
    public function getFeedbacks()
    {
        return $this->feedbacks;
    }

    /**
     *
     */
    public function setFeedbacks($feedbacks)
    {
        $this->feedbacks = $feedbacks;
    }


    /**
     *
     * @return type
     */
    public function getSurveyanswers()
    {
        return $this->surveyanswers;
    }

    /**
     *
     */
    public function setSurveyanswers($surveyanswers)
    {
        $this->surveyanswers = $surveyanswers;
    }

    /**
     * Set slug
     *
     * @param string $slug
     * @return ServicesCategory
     */
    public function setSlug($slug)
    {
        $this->slug = $slug;

        return $this;
    }

    /**
     * Get slug
     *
     * @return string
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * Set salutarisId
     *
     * @param string $salutarisId
     * @return Course
     */
    public function setSalutarisId($salutarisId)
    {
        $this->salutarisId = $salutarisId;

        return $this;
    }

    /**
     * Get salutarisId
     *
     * @return string
     */
    public function getSalutarisId()
    {
        return $this->salutarisId;
    }

    /**
     * Upload image
     */

    // Constante com o caminho para salvar a imagem screenshot
    const UPLOAD_PATH_COURSE_CERTIFICATE = 'uploads/course/certificate';
    const UPLOAD_PATH_COURSE_CERTIFICATE_BACK = 'uploads/course/certificate_back';
    const UPLOAD_PATH_COURSE_COVER = 'uploads/course/cover';
    const UPLOAD_PATH_COURSE_SCORM = 'uploads/course/scorm';

    // 512000  bytes / 500 kbytes
    // 1048576 bytes / 1024 kbytes
    // 2097152 bytes / 2048 kbytes

    /**
     * @Assert\File(
     *     maxSize = "3072k",
     *     maxSizeMessage = "O tamanho da imagem é muito grande ({{ size }} {{ suffix }}), escolha uma imagem de até {{ limit }} {{ suffix }}",
     *     mimeTypes = {"image/jpeg", "image/gif", "image/png"},
     *     mimeTypesMessage = "Formato de arquivo inválido. Formatos permitidos: .gif, .jpeg e .png"
     * )
     */
    private $certificateTemp;

    /**
     * @Assert\File(
     *     maxSize = "3072k",
     *     maxSizeMessage = "O tamanho da imagem é muito grande ({{ size }} {{ suffix }}), escolha uma imagem de até {{ limit }} {{ suffix }}",
     *     mimeTypes = {"image/jpeg", "image/gif", "image/png"},
     *     mimeTypesMessage = "Formato de arquivo inválido. Formatos permitidos: .gif, .jpeg e .png"
     * )
     */
    private $certificateBackTemp;

    /**
     * @Assert\File(
     *     maxSize = "3072k",
     *     maxSizeMessage = "O tamanho da imagem é muito grande ({{ size }} {{ suffix }}), escolha uma imagem de até {{ limit }} {{ suffix }}",
     *     mimeTypes = {"image/jpeg", "image/gif", "image/png"},
     *     mimeTypesMessage = "Formato de arquivo inválido. Formatos permitidos: .gif, .jpeg e .png"
     * )
     */
    private $coverTemp;

    private $scormFileTemp;

    /**
     * Sets certificateTemp
     *
     * @param UploadedFile $certificateTemp
     */
    public function setCertificateTemp(UploadedFile $certificateTemp = null)
    {
        $this->certificateTemp = $certificateTemp;
    }

    /**
     * Get certificateTemp
     *
     * @return UploadedFile
     */
    public function getCertificateTemp()
    {
        return $this->certificateTemp;
    }

    /**
     * Sets certificateBackTemp
     *
     * @param UploadedFile $certificateBackTemp
     */
    public function setCertificateBackTemp(UploadedFile $certificateBackTemp = null)
    {
        $this->certificateBackTemp = $certificateBackTemp;
    }

    /**
     * Get certificateBackTemp
     *
     * @return UploadedFile
     */
    public function getCertificateBackTemp()
    {
        return $this->certificateBackTemp;
    }

    /**
     * Sets coverTemp
     *
     * @param UploadedFile $coverTemp
     */
    public function setCoverTemp(UploadedFile $coverTemp = null)
    {
        $this->coverTemp = $coverTemp;
    }

    /**
     * Get coverTemp
     *
     * @return UploadedFile
     */
    public function getCoverTemp()
    {
        return $this->coverTemp;
    }

    /**
     * Sets scormFileTemp
     *
     * @param UploadedFile $scormFileTemp
     */
    public function setScormFileTemp(UploadedFile $scormFileTemp = null)
    {
        $this->scormFileTemp = $scormFileTemp;
    }

    /**
     * Get scormFileTemp
     *
     * @return UploadedFile
     */
    public function getScormFileTemp()
    {
        return $this->scormFileTemp;
    }

    /**
     * Unlink Photo (Apagar foto quando excluir objeto)
     */
    public function unlinkImages()
    {
        if ($this->getCertificate() != null) {
            $pathFile = Course::UPLOAD_PATH_COURSE_CERTIFICATE ."/". $this->getCertificate();
            if (file_exists($pathFile)) {
                unlink($pathFile);
            }
        }
        if ($this->getCertificateBack() != null) {
            $pathFile = Course::UPLOAD_PATH_COURSE_CERTIFICATE_BACK ."/". $this->getCertificateBack();
            if (file_exists($pathFile)) {
                unlink($pathFile);
            }
        }
        if ($this->getCover() != null) {
            $pathFile = Course::UPLOAD_PATH_COURSE_COVER ."/". $this->getCover();
            if (file_exists($pathFile)) {
                unlink($pathFile);
            }
        }
    }

    /**
     * Manages the copying of the file to the relevant place on the server
     */
    public function uploadImage()
    {

        //Upload de Certificado
        if ($this->getCertificateTemp()!=null) {
            //Se o diretorio não existir, cria
            if (!file_exists(Course::UPLOAD_PATH_COURSE_CERTIFICATE)) {
                mkdir(Course::UPLOAD_PATH_COURSE_CERTIFICATE, 0755, true);
            }
            if (($this->getCertificateTemp() != $this->getCertificate())
                && (null !== $this->getCertificate())
            ) {
                unlink(Course::UPLOAD_PATH_COURSE_CERTIFICATE ."/". $this->getCertificate());
            }

            // Generate a unique name for the file before saving it
            $fileName = md5(uniqid()).'.'.$this->getCertificateTemp()->guessExtension();

            UploadService::compress($this->getCertificateTemp(), Course::UPLOAD_PATH_COURSE_CERTIFICATE."/".$fileName, 100);

            // set the path property to the filename where you've saved the file
            $this->certificate = $fileName;

            // clean up the file property as you won't need it anymore
            $this->setCertificateTemp(null);
        }

        //Upload de Certificado - Back
        if ($this->getCertificateBackTemp()!=null) {
            //Se o diretorio não existir, cria
            if (!file_exists(Course::UPLOAD_PATH_COURSE_CERTIFICATE_BACK)) {
                mkdir(Course::UPLOAD_PATH_COURSE_CERTIFICATE_BACK, 0755, true);
            }
            if (($this->getCertificateBackTemp() != $this->getCertificateBack())
                && (null !== $this->getCertificateBack())
            ) {
                unlink(Course::UPLOAD_PATH_COURSE_CERTIFICATE_BACK ."/". $this->getCertificateBack());
            }

            // Generate a unique name for the file before saving it
            $fileName = md5(uniqid()).'.'.$this->getCertificateBackTemp()->guessExtension();

            UploadService::compress($this->getCertificateBackTemp(), Course::UPLOAD_PATH_COURSE_CERTIFICATE_BACK."/".$fileName, 100);

            // set the path property to the filename where you've saved the file
            $this->certificate_back = $fileName;

            // clean up the file property as you won't need it anymore
            $this->setCertificateBackTemp(null);
        }

        //Upload de cover
        if ($this->getCoverTemp()!=null) {
            //Se o diretorio não existir, cria
            if (!file_exists(Course::UPLOAD_PATH_COURSE_COVER)) {
                mkdir(Course::UPLOAD_PATH_COURSE_COVER, 0755, true);
            }
            if (($this->getCoverTemp() != $this->getCover())
                && (null !== $this->getCover())
            ) {
                unlink(Course::UPLOAD_PATH_COURSE_COVER ."/". $this->getCover());
            }

            // Generate a unique name for the file before saving it
            $fileName = md5(uniqid()).'.'.$this->getCoverTemp()->guessExtension();

            UploadService::compress($this->getCoverTemp(), Course::UPLOAD_PATH_COURSE_COVER."/".$fileName, 100);

            // set the path property to the filename where you've saved the file
            $this->cover = $fileName;

            // clean up the file property as you won't need it anymore
            $this->setCoverTemp(null);
        }

        //Upload de scorm
        if ($this->getScormFileTemp()!=null) {
            //Se o diretorio não existir, cria
            if (!file_exists(Course::UPLOAD_PATH_COURSE_SCORM)) {
                mkdir(Course::UPLOAD_PATH_COURSE_SCORM, 0755, true);
            }
            if (($this->getScormFileTemp() != $this->getScormFile())
                && (null !== $this->getScormFile())
            ) {
                unlink(Course::UPLOAD_PATH_COURSE_SCORM ."/". $this->getScormFile());
            }

            // Generate a unique name for the file before saving it
            $fileName = md5(uniqid());
            $fullFileName = $fileName.'.'.$this->getScormFileTemp()->guessExtension();

            UploadService::upload($this->getScormFileTemp(), Course::UPLOAD_PATH_COURSE_SCORM."/".$fullFileName);

            // set the path property to the filename where you've saved the file
            $this->scormFile = $fullFileName;

            // clean up the file property as you won't need it anymore
            $this->setScormFileTemp(null);

            //Extrair o arquivo no diretório
            $zip = new \ZipArchive;
            $res = $zip->open(Course::UPLOAD_PATH_COURSE_SCORM."/".$fullFileName);
            if ($res === true) {
                $zip->extractTo(Course::UPLOAD_PATH_COURSE_SCORM."/".$fileName);
                $zip->close();
            } else {
            }
        }
    }

    /**
     * Lifecycle callback to upload the file to the server
     * @ORM\PrePersist
     * @ORM\PreUpdate
     */
    public function lifecycleFileUpload()
    {
        $this->uploadImage();
    }

    /**
     * @ORM\PostLoad()
     */
    public function postLoad()
    {
        $this->dtUpdate = new \DateTime();
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getIdMediaDegustacao()
    {
        return $this->idMediaDegustacao;
    }

    /**
     * Set idmediadegustacao
     *
     * @param string $idmediadegustacao
     *
     * @return Course
     */
    public function setIdMediaDegustacao($idmediadegustacao)
    {
        $this->idMediaDegustacao = $idmediadegustacao;

        return $this;
    }

    /**
     * Set notaMedia
     *
     * @param string $notaMedia
     *
     * @return Course
     */
    public function setNotaMedia($notaMedia)
    {
        $this->notaMedia = $notaMedia;

        return $this;
    }

    /**
     * Get notaMedia
     *
     * @return decimal
     */
    public function getNotaMedia()
    {
        return $this->notaMedia;
    }

    /**
     * Set dtInitial
     *
     * @param \DateTime $dtInitial
     *
     * @return Payment
     */
    public function setDtInitial($dtInitial)
    {
        $this->dtInitial = $dtInitial;

        return $this;
    }

    /**
     * Get dtInitial
     *
     * @return \DateTime
     */
    public function getDtInitial()
    {
        return $this->dtInitial;
    }

    /**
     * Set dtEnd
     *
     * @param \DateTime $dtEnd
     *
     * @return Payment
     */
    public function setDtEnd($dtEnd)
    {
        $this->dtEnd = $dtEnd;

        return $this;
    }

    /**
     * Get dtInitial
     *
     * @return \DateTime
     */
    public function getDtEnd()
    {
        return $this->dtEnd;
    }

    /**
     * Set dtInscriptionBegin
     *
     * @param \DateTime $dtInscriptionBegin
     *
     * @return Payment
     */
    public function setDtInscriptionBegin($dtInscriptionBegin)
    {
        $this->dtInscriptionBegin = $dtInscriptionBegin;

        return $this;
    }

    /**
     * Get dtInscriptionBegin
     *
     * @return \DateTime
     */
    public function getDtInscriptionBegin()
    {
        return $this->dtInscriptionBegin;
    }

    /**
     * Set dtInscriptionEnd
     *
     * @param \DateTime $dtInscriptionEnd
     *
     * @return Payment
     */
    public function setDtInscriptionEnd($dtInscriptionEnd)
    {
        $this->dtInscriptionEnd = $dtInscriptionEnd;

        return $this;
    }

    /**
     * Get dtInscriptionEnd
     *
     * @return \DateTime
     */
    public function getDtInscriptionEnd()
    {
        return $this->dtInscriptionEnd;
    }

    /**
     * Set dtCancel
     *
     * @param \DateTime $dtCancel
     *
     * @return Payment
     */
    public function setDtCancel($dtCancel)
    {
        $this->dtCancel = $dtCancel;

        return $this;
    }

    /**
     * Get dtCancel
     *
     * @return \DateTime
     */
    public function getDtCancel()
    {
        return $this->dtCancel;
    }

    /**
     * Set dtCreation
     *
     * @param \DateTime $dtCreation
     *
     * @return Payment
     */
    public function setDtCreation($dtCreation)
    {
        $this->dtCreation = $dtCreation;

        return $this;
    }

    /**
     * Get dtCreation
     *
     * @return \DateTime
     */
    public function getDtCreation()
    {
        return $this->dtCreation;
    }

    /**
     * Set dtUpdate
     *
     * @param \DateTime $dtUpdate
     *
     * @return Payment
     */
    public function setDtUpdate($dtUpdate)
    {
        $this->dtUpdate = $dtUpdate;

        return $this;
    }

    /**
     * Get dtUpdate
     *
     * @return \DateTime
     */
    public function getDtUpdate()
    {
        return $this->dtUpdate;
    }

    /**
     *
     * @return string
     */
    public function getAutor()
    {
        return $this->autor;
    }

    /**
     *
     */
    public function setAutor($autor)
    {
        $this->autor = $autor;
    }

    /**
     *
     * @return integer
     */
    public function getDuracaoCurso()
    {
        return $this->duracaoCurso;
    }

    /**
     *
     */
    public function setDuracaoCurso($duracaoCurso)
    {
        $this->duracaoCurso = $duracaoCurso;
    }

    /**
     *
     * @return integer
     */
    public function getModality()
    {
        return $this->modality;
    }

    /**
     *
     */
    public function setModality($modality)
    {
        $this->modality = $modality;
    }

    /**
     * Set disponibleDays
     *
     * @param Integer $disponibleDays
     * @return Course
     */
    public function setDisponibleDays($disponibleDays)
    {
        $this->disponibleDays = $disponibleDays;

        return $this;
    }

    /**
     * Get disponibleDays
     *
     * @return integer
     */
    public function getDisponibleDays()
    {
        return $this->disponibleDays;
    }

    /**
     * Set pontuation
     *
     * @param Integer $pontuation
     * @return Course
     */
    public function setPontuation($pontuation)
    {
        $this->pontuation = $pontuation;

        return $this;
    }

    /**
     * Get pontuation
     *
     * @return integer
     */
    public function getPontuation()
    {
        return $this->pontuation;
    }

    /**
     * Set codcurso
     *
     * @param Integer $codcurso
     * @return Course
     */
    public function setCodcurso($codcurso)
    {
        $this->codcurso = $codcurso;

        return $this;
    }

    /**
     * Get codcurso
     *
     * @return integer
     */
    public function getCodcurso()
    {
        return $this->codcurso;
    }

    /**
     * Set operador
     *
     * @param Integer $operador
     * @return Course
     */
    public function setOperador($operador)
    {
        $this->operador = $operador;

        return $this;
    }

    /**
     * Get operador
     *
     * @return integer
     */
    public function getOperador()
    {
        return $this->operador;
    }

    /**
     * Set quantvagas
     *
     * @param Integer $quantvagas
     * @return Course
     */
    public function setQuantvagas($quantvagas)
    {
        $this->quantvagas = $quantvagas;

        return $this;
    }

    /**
     * Get quantvagas
     *
     * @return integer
     */
    public function getQuantvagas()
    {
        return $this->quantvagas;
    }

    /**
     * Set category
     *
     * @param Category $category
     * @return Class
     */
    public function setCategory($category = null)
    {
        $this->category = $category;

        return $this;
    }

    /**
     * Get category
     *
     * @return Class
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * Set survey
     *
     * @param Survey $survey
     * @return Class
     */
    public function setSurvey($survey = null)
    {
        $this->survey = $survey;

        return $this;
    }

    /**
     * Get survey
     *
     * @return Class
     */
    public function getSurvey()
    {
        return $this->survey;
    }

    /**
     * Set active
     *
     * @param boolean $active
     *
     * @return Course
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * Get active
     *
     * @return boolean
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Set autoInscription
     *
     * @param boolean $autoInscription
     *
     * @return Course
     */
    public function setAutoInscription($autoInscription)
    {
        $this->autoInscription = $autoInscription;

        return $this;
    }

    /**
     * Get autoInscription
     *
     * @return boolean
     */
    public function getAutoInscription()
    {
        return $this->autoInscription;
    }

    /**
     * Set moduleDependency
     *
     * @param boolean $moduleDependency
     *
     * @return Course
     */
    public function setModuleDependency($moduleDependency)
    {
        $this->moduleDependency = $moduleDependency;

        return $this;
    }

    /**
     * Get moduleDependency
     *
     * @return boolean
     */
    public function getModuleDependency()
    {
        return $this->moduleDependency;
    }

    //transient
    private $timelineStatus;
    private $timelineChildren;
    private $timelineIndex;

    /**
     * Set timelineStatus
     *
     * @param boolean $timelineStatus
     *
     * @return Course
     */
    public function setTimelineStatus($timelineStatus)
    {
        $this->timelineStatus = $timelineStatus;

        return $this;
    }

    /**
     * Get timelineStatus
     *
     * @return boolean
     */
    public function getTimelineStatus()
    {
        return $this->timelineStatus;
    }

    /**
     * Set timelineChildren
     *
     * @param boolean $timelineChildren
     *
     * @return Course
     */
    public function setTimelineChildren($timelineChildren)
    {
        $this->timelineChildren = $timelineChildren;

        return $this;
    }

    /**
     * Get timelineChildren
     *
     * @return boolean
     */
    public function getTimelineChildren()
    {
        return $this->timelineChildren;
    }

    /**
     * Set timelineIndex
     *
     * @param boolean $timelineIndex
     *
     * @return Course
     */
    public function setTimelineIndex($timelineIndex)
    {
        $this->timelineIndex = $timelineIndex;

        return $this;
    }

    /**
     * Get timelineIndex
     *
     * @return boolean
     */
    public function getTimelineIndex()
    {
        return $this->timelineIndex;
    }

    /**
     * Set linkTrailExternal
     *
     * @param string $linkTrailExternal
     *
     * @return Course
     */
    public function setLinkTrailExternal($linkTrailExternal)
    {
        $this->linkTrailExternal = $linkTrailExternal;

        return $this;
    }

    /**
     * Get linkTrailExternal
     *
     * @return string
     */
    public function getLinkTrailExternal()
    {
        return $this->linkTrailExternal;
    }

    /**
     * Set conclusionLink
     *
     * @param string $conclusionLink
     *
     * @return Course
     */
    public function setConclusionLink($conclusionLink)
    {
        $this->conclusionLink = $conclusionLink;

        return $this;
    }

    /**
     * Get conclusionLink
     *
     * @return string
     */
    public function getConclusionLink()
    {
        return $this->conclusionLink;
    }

    public function getLastModules()
    {
        $total = 0;
        foreach ($this->getModules() as $module) {
            $total++;
        }
        return $total;
    }

    public function getTotalModules()
    {
        $total = 0;
        foreach ($this->getModules() as $module) {
            $total++;
        }
        return $total;
    }

    public function getTotalLessons()
    {
        $total = 0;
        foreach ($this->getModules() as $module) {
            foreach ($module->getLessons() as $lesson) {
                $total++;
            }
        }
        return $total;
    }

    public function getTotalEvaluations()
    {
        $total = 0;
        foreach ($this->getModules() as $module) {
            foreach ($module->getEvaluations() as $evaluation) {
                $total++;
            }
        }
        return $total;
    }

    /**
     * Add courseAccessControl
     *
     * @param \AppBundle\Entity\CourseAccessControl $courseAccessControl
     *
     * @return Course
     */
    public function addCourseAccessControl(CourseAccessControl $courseAccessControl)
    {
        $courseAccessControl->setCourse($this);
        $this->courseAccessControls->add($courseAccessControl);
    }

    /**
     * Remove courseAccessControl
     *
     * @param \AppBundle\Entity\CourseAccessControl $courseAccessControl
     */
    public function removeCourseAccessControl(CourseAccessControl $courseAccessControl)
    {
        $this->courseAccessControls->removeElement($courseAccessControl);
    }

    /**
     * Set courseAccessControls
     *
     * @param string $courseAccessControls
     * @return Course
     */
    public function setCourseAccessControls($courseAccessControls)
    {
        $this->courseAccessControls = $courseAccessControls;

        return $this;
    }

    /**
     * Get CourseAccessControls
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCourseAccessControls()
    {
        return $this->courseAccessControls;
    }

    public function isAccessAvailable($user){
        foreach ($this->getCourseAccessControls() as $courseAccessControls) {
            if($courseAccessControls->getAccess() == "Todos" || 
                ($user->getUsergroup() && $courseAccessControls->getAccess() == $user->getUsergroup()->getId())
            ){
                return true;
            }
        }
        return false;
    }
}
