<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Type;

/**
 * Class
 *
 * @ORM\Table(name="course_class")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\CourseClassRepository")
 * @ExclusionPolicy("all")
 */
class CourseClass
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Expose
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="string", length=255, nullable=true)
     * @Expose
     */
    private $description;

    /**
     * @var Course
     *
     * @ORM\ManyToOne(targetEntity="Course", inversedBy="courseclass")
     * @ORM\JoinColumn(name="course_id", referencedColumnName="id", nullable=true)
     * @Expose
     */
    protected $course;

    /**
     *
     * @ORM\ManyToOne(targetEntity="CourseClassStatus")
     * @ORM\JoinColumn(name="course_class_status_id", referencedColumnName="id")
     */
    private $courseClassStatus;

    /**
     * @var \DateTime
     * @ORM\Column(name="dt_begin", type="datetime", nullable=true)
     */
    private $dtBegin;

    /**
     * @var \DateTime
     * @ORM\Column(name="dt_end", type="datetime", nullable=true)
     */
    private $dtEnd;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_creation", type="datetime")
     * @Gedmo\Timestampable(on="create")
     * @Expose
     */
    private $dtCreation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_update", type="datetime")
     * @Gedmo\Timestampable(on="update")
     * @Expose
     */
    private $dtUpdate;

    /**
     * @ORM\OneToMany(targetEntity="EventClass", mappedBy="courseClass", cascade={"all"}, orphanRemoval=true)
     */
    private $eventClass;

    /**
     * @ORM\OneToMany(targetEntity="InscriptionClass", mappedBy="courseClass", cascade={"all"})
     */
    protected $inscriptionsClass;


    public function __construct()
    {
        $this->eventClass = new ArrayCollection();
        $this->inscriptionsClass = new ArrayCollection();
    }

    /**
     * Set id
     *
     * @param integer $id;
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return Lesson
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set course
     *
     * @param Course $course
     * @return Class
     */
    public function setCourse($course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course
     *
     * @return Class
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set courseClassStatus
     *
     * @param CourseClassStatus $courseClassStatus
     * @return CourseClass
     */
    public function setCourseClassStatus($courseClassStatus = null)
    {
        $this->courseClassStatus = $courseClassStatus;

        return $this;
    }

    /**
     * Get courseClassStatus
     *
     * @return CourseClassStatus
     */
    public function getCourseClassStatus()
    {
        return $this->courseClassStatus;
    }

    /**
     * Set dtBegin
     *
     * @param datetime $dtBegin
     * @return Inscription
     */
    public function setDtBegin($dtBegin = null)
    {
        $this->dtBegin = $dtBegin;

        return $this;
    }

    /**
     * Get dtBegin
     *
     * @return Class
     */
    public function getDtBegin()
    {
        return $this->dtBegin;
    }

    /**
     * Set dtEnd
     *
     * @param datetime $dtEnd
     * @return Inscription
     */
    public function setDtEnd($dtEnd = null)
    {
        $this->dtEnd = $dtEnd;

        return $this;
    }

    /**
     * Get dtEnd
     *
     * @return Class
     */
    public function getDtEnd()
    {
        return $this->dtEnd;
    }

    /**
     * Set dtCreation
     *
     * @param \DateTime $dtCreation
     *
     * @return Payment
     */
    public function setDtCreation($dtCreation)
    {
        $this->dtCreation = $dtCreation;

        return $this;
    }

    /**
     * Get dtCreation
     *
     * @return \DateTime
     */
    public function getDtCreation()
    {
        return $this->dtCreation;
    }

    /**
     * Set dtUpdate
     *
     * @param \DateTime $dtUpdate
     *
     * @return Payment
     */
    public function setDtUpdate($dtUpdate)
    {
        $this->dtUpdate = $dtUpdate;

        return $this;
    }

    /**
     * Get dtUpdate
     *
     * @return \DateTime
     */
    public function getDtUpdate()
    {
        return $this->dtUpdate;
    }

    public function addEventClass(EventClass $eventClass)
    {
        $eventClass->setCourseClass($this);

        $this->eventClass->add($eventClass);
    }

    public function removeEventClass(EventClass $eventClass)
    {
        $this->eventClass->removeElement($eventClass);
    }

    /**
     * Set eventClass
     *
     * @param string $eventClass
     * @return Question
     */
    public function setEventClass($eventClass)
    {
        $this->eventClass = $eventClass;

        return $this;
    }

    /**
     * Get eventClass
     *
     * @return string
     */
    public function getEventClass()
    {
        return $this->eventClass;
    }

    /**
     *
     * @return type
     */
    public function getInscriptionsClass()
    {
        return $this->inscriptionsClass;
    }

    /**
     *
     */
    public function setInscriptionsClass($inscriptionsClass)
    {
        $this->inscriptionsClass = $inscriptionsClass;
    }

    public function isClassOpened(){
        $today = new \DateTime("now");
        // if($this->getDtBegin() <= $today){
        if($this->getDtBegin() <= $today && $this->getDtEnd() >= $today){
            return true;
        }
        return false;
    }

    public function isEventOpened(){
        $today = new \DateTime("now");
        foreach ($this->eventClass as $item) {
            if($item->getDtBegin() <= $today && $item->getDtEnd() >= $today){
                return true;
            }
        }
        return false;
    }
}
