<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EnterpriseAccessControl
 *
 * @ORM\Table(name="enterprise_access_control")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\EnterpriseAccessControlRepository")
 */
class EnterpriseAccessControl
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var AccessControl
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\AccessControl")
     * @ORM\JoinColumn(name="access_control_id", referencedColumnName="id", nullable=true, onDelete="SET NULL")
     */
    private $accessControl;

    /**
     * @var string
     *
     * @ORM\Column(name="num_enterprise", type="integer", nullable=true)
     */
    private $enterprise;

    public function __toString()
    {
        return $this->enterprise;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set enterprise
     *
     * @param integer $enterprise
     *
     * @return EnterpriseAccessControl
     */
    public function setEnterprise($enterprise)
    {
        $this->enterprise = $enterprise;

        return $this;
    }

    /**
     * Get enterprise
     *
     * @return integer
     */
    public function getEnterprise()
    {
        return $this->enterprise;
    }

    /**
     * Set accessControl
     *
     * @param \AppBundle\Entity\AccessControl $accessControl
     *
     * @return EnterpriseAccessControl
     */
    public function setAccessControl($accessControl)
    {
        $this->accessControl = $accessControl;

        return $this;
    }

    /**
     * Get accessControl
     *
     * @return \AppBundle\Entity\AccessControl
     */
    public function getAccessControl()
    {
        return $this->accessControl;
    }
}
