<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Type;

/**
 * Class
 *
 * @ORM\Table(name="evaluation")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\EvaluationRepository")
 * @ExclusionPolicy("all")
 */
class Evaluation
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Expose
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     * @Expose
     */
    private $name;

    /**
     * @var Module
     *
     * @ORM\ManyToOne(targetEntity="Module", inversedBy="evaluations")
     * @ORM\JoinColumn(name="module_id", referencedColumnName="id", nullable=true)
     * @Expose
     */
    private $module;

    /**
     * @ORM\OneToMany(targetEntity="Question", mappedBy="evaluation", cascade={"all"}, orphanRemoval=true)
     */
    private $questions;

    /**
     * @var integer
     *
     * @ORM\Column(name="minimum_grade", type="integer")
     */
    private $minimumGrade;

    /**
     * @var integer
     *
     * @ORM\Column(name="number_questions", type="integer", nullable=true)
     */
    private $numberQuestions;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_creation", type="datetime")
     * @Gedmo\Timestampable(on="create")
     * @Expose
     */
    private $dtCreation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_update", type="datetime")
     * @Gedmo\Timestampable(on="update")
     * @Expose
     */
    private $dtUpdate;

    public function __toString()
    {
        return $this->id;
    }

    public function __construct()
    {
        $this->questions = new ArrayCollection();
    }

    /**
     * Set id
     *
     * @param integer $id;
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Evaluation
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set module
     *
     * @param Module $module
     * @return Evaluation
     */
    public function setModule($module = null)
    {
        $this->module = $module;

        return $this;
    }

    /**
     * Get module
     *
     * @return Class
     */
    public function getModule()
    {
        return $this->module;
    }

    /**
     * Set minimumGrade
     *
     * @param Integer $minimumGrade
     *
     * @return Evaluation
     */
    public function setMinimumGrade($minimumGrade)
    {
        $this->minimumGrade = $minimumGrade;

        return $this;
    }

    /**
     * Get minimumGrade
     *
     * @return Evaluation
     */
    public function getMinimumGrade()
    {
        return $this->minimumGrade;
    }

    /**
     * Set numberQuestions
     *
     * @param Integer $numberQuestions
     *
     * @return Evaluation
     */
    public function setNumberQuestions($numberQuestions)
    {
        $this->numberQuestions = $numberQuestions;

        return $this;
    }

    /**
     * Get numberQuestions
     *
     * @return Evaluation
     */
    public function getNumberQuestions()
    {
        return $this->numberQuestions;
    }

    /**
     * Set dtCreation
     *
     * @param \DateTime $dtCreation
     *
     * @return Evaluation
     */
    public function setDtCreation($dtCreation)
    {
        $this->dtCreation = $dtCreation;

        return $this;
    }

    /**
     * Get dtCreation
     *
     * @return \DateTime
     */
    public function getDtCreation()
    {
        return $this->dtCreation;
    }

    /**
     * Set dtUpdate
     *
     * @param \DateTime $dtUpdate
     *
     * @return Payment
     */
    public function setDtUpdate($dtUpdate)
    {
        $this->dtUpdate = $dtUpdate;

        return $this;
    }

    /**
     * Get dtUpdate
     *
     * @return \DateTime
     */
    public function getDtUpdate()
    {
        return $this->dtUpdate;
    }

    /**
     * Set questions
     *
     * @param string $questions
     * @return Question
     */
    public function setQuestions($questions)
    {
        $this->questions = $questions;

        return $this;
    }

    /**
     * Get questions
     *
     * @return string
     */
    public function getQuestions()
    {
        return $this->questions;
    }
}
