<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Type;

/**
 * Class
 *
 * @ORM\Table(name="event_class")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\EventClassRepository")
 * @ExclusionPolicy("all")
 */
class EventClass
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Expose
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="string", length=255, nullable=true)
     * @Expose
     */
    private $description;

    /**
     * @var Course
     *
     * @ORM\ManyToOne(targetEntity="CourseClass", inversedBy="eventClass")
     * @ORM\JoinColumn(name="courseclass_id", referencedColumnName="id", nullable=true)
     * @Expose
     */
    protected $courseClass;

    /**
     * @var \DateTime
     * @ORM\Column(name="dt_begin", type="datetime", nullable=true)
     */
    private $dtBegin;

    /**
     * @var \DateTime
     * @ORM\Column(name="dt_end", type="datetime", nullable=true)
     */
    private $dtEnd;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_creation", type="datetime")
     * @Gedmo\Timestampable(on="create")
     * @Expose
     */
    private $dtCreation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_update", type="datetime")
     * @Gedmo\Timestampable(on="update")
     * @Expose
     */
    private $dtUpdate;


    public function __construct()
    {
    }

    /**
     * Set id
     *
     * @param integer $id;
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return Lesson
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set courseClass
     *
     * @param CourseClass $courseClass
     * @return Class
     */
    public function setCourseClass($courseClass = null)
    {
        $this->courseClass = $courseClass;

        return $this;
    }

    /**
     * Get course
     *
     * @return Class
     */
    public function getCourseClass()
    {
        return $this->courseClass;
    }

    /**
     * Set dtBegin
     *
     * @param datetime $dtBegin
     * @return Inscription
     */
    public function setDtBegin($dtBegin = null)
    {
        $this->dtBegin = $dtBegin;

        return $this;
    }

    /**
     * Get dtBegin
     *
     * @return Class
     */
    public function getDtBegin()
    {
        return $this->dtBegin;
    }

    /**
     * Set dtEnd
     *
     * @param datetime $dtEnd
     * @return Inscription
     */
    public function setDtEnd($dtEnd = null)
    {
        $this->dtEnd = $dtEnd;

        return $this;
    }

    /**
     * Get dtEnd
     *
     * @return Class
     */
    public function getDtEnd()
    {
        return $this->dtEnd;
    }

    /**
     * Set dtCreation
     *
     * @param \DateTime $dtCreation
     *
     * @return Payment
     */
    public function setDtCreation($dtCreation)
    {
        $this->dtCreation = $dtCreation;

        return $this;
    }

    /**
     * Get dtCreation
     *
     * @return \DateTime
     */
    public function getDtCreation()
    {
        return $this->dtCreation;
    }

    /**
     * Set dtUpdate
     *
     * @param \DateTime $dtUpdate
     *
     * @return Payment
     */
    public function setDtUpdate($dtUpdate)
    {
        $this->dtUpdate = $dtUpdate;

        return $this;
    }

    /**
     * Get dtUpdate
     *
     * @return \DateTime
     */
    public function getDtUpdate()
    {
        return $this->dtUpdate;
    }
}
