<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Type;

/**
 * Class
 *
 * @ORM\Table(name="inscription")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\InscriptionRepository")
 * @ExclusionPolicy("all")
 */
class Inscription
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Expose
     */
    private $id;

    /**
     * @var Course
     *
     * @ORM\ManyToOne(targetEntity="UserBundle\Entity\User", inversedBy="inscriptions")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=true)
     * @Expose
     */
    private $user;

    /**
     * @var Course
     *
     * @ORM\ManyToOne(targetEntity="Course", inversedBy="inscriptions")
     * @ORM\JoinColumn(name="course_id", referencedColumnName="id", nullable=true)
     */
    private $course;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_creation", type="datetime")
     * @Gedmo\Timestampable(on="create")
     * @Expose
     */
    private $dtCreation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_update", type="datetime")
     * @Gedmo\Timestampable(on="update")
     * @Expose
     */
    private $dtUpdate;

    /**
     *
     * @ORM\ManyToOne(targetEntity="InscriptionStatus")
     * @ORM\JoinColumn(name="inscriptionstatus_id", referencedColumnName="id")
     */
    private $inscription_status;
    
    /**
     * @var incriptionlessons
     *
     * @ORM\OneToMany(targetEntity="InscriptionLesson", mappedBy="inscription", cascade=
     * {"all"})
     */
    private $inscriptionlessons;

    /**
     * @var integer
     *
     * @ORM\Column(name="attempts", type="integer", nullable=true)
     */
    private $attempts = 100;

    /**
     * @var \DateTime
     * @ORM\Column(name="dt_begin", type="datetime", nullable=true)
     */
    private $dtBegin;

    /**
     * @var \DateTime
     * @ORM\Column(name="dt_end", type="datetime", nullable=true)
     */
    private $dtEnd;

    public function __construct()
    {
        $this->inscriptionlessons = new ArrayCollection();
    }

    public function __toString()
    {
        return "ID: ".$this->id;
    }

    /**
     * Set id
     *
     * @param integer $id;
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set user
     *
     * @param User $user
     * @return Class
     */
    public function setUser($user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return Class
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set course
     *
     * @param Course $course
     * @return Class
     */
    public function setCourse($course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course
     *
     * @return Class
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set dtCreation
     *
     * @param Inscription $dtCreation
     * @return Class
     */
    public function setDtCreation($dtCreation = null)
    {
        $this->dtCreation = $dtCreation;

        return $this;
    }

    /**
     * Get dtCreation
     *
     * @return Class
     */
    public function getDtCreation()
    {
        return $this->dtCreation;
    }

    /**
     * Set dtUpdate
     *
     * @param Inscription $dtUpdate
     * @return Class
     */
    public function setDtUpdate($dtUpdate = null)
    {
        $this->dtUpdate = $dtUpdate;

        return $this;
    }

    /**
     * Get dtUpdate
     *
     * @return Class
     */
    public function getDtUpdate()
    {
        return $this->dtUpdate;
    }

    /**
     * Set $inscription_status
     *
     * @param InscriptionStatus $inscription_status
     * @return Inscription
     */
    public function setInscriptionStatus($inscription_status)
    {
        $this->inscription_status = $inscription_status;

        return $this;
    }

    /**
     * Get inscription_status
     *
     * @return InscriptionStatus
     */
    public function getInscriptionStatus()
    {
        return $this->inscription_status;
    }

    /**
      * Set inscriptionlessons
      *
      * @param inscriptionlessons $inscriptionlessons
      * @return Class
      */
    public function setInscriptionlessons($inscriptionlessons = null)
    {
        $this->inscriptionlessons = $inscriptionlessons;

        return $this;
    }

    /**
     * Get inscriptionlessons
     *
     * @return Class
     */
    public function getInscriptionlessons()
    {
        return $this->inscriptionlessons;
    }

    /**
     * Set dtBegin
     *
     * @param datetime $dtBegin
     * @return Inscription
     */
    public function setDtBegin($dtBegin = null)
    {
        $this->dtBegin = $dtBegin;

        return $this;
    }

    /**
     * Get dtBegin
     *
     * @return Class
     */
    public function getDtBegin()
    {
        return $this->dtBegin;
    }

    /**
     * Set dtEnd
     *
     * @param datetime $dtEnd
     * @return Inscription
     */
    public function setDtEnd($dtEnd = null)
    {
        $this->dtEnd = $dtEnd;

        return $this;
    }

    /**
     * Get dtEnd
     *
     * @return Class
     */
    public function getDtEnd()
    {
        return $this->dtEnd;
    }

    public function getFirstLesson()
    {
        $lessonAux = $this->inscriptionlessons[0];
        foreach ($this->inscriptionlessons as $inscriptionlesson) {
            if ($lessonAux->getId() < $inscriptionlesson->getId()) {
                $lessonAux = $inscriptionlesson;
            }
        }
        return $lessonAux;
    }

    /**
     * Set attempts
     *
     * @param integer $attempts
     *
     * @return Inscription
     */
    public function setAttempts($attempts)
    {
        $this->attempts = $attempts;

        return $this;
    }

    /**
     * Get attempts
     *
     * @return integer
     */
    public function getAttempts()
    {
        return $this->attempts;
    }

    /**
     * Add inscriptionlesson
     *
     * @param \AppBundle\Entity\InscriptionLesson $inscriptionlesson
     *
     * @return Inscription
     */
    public function addInscriptionlesson(\AppBundle\Entity\InscriptionLesson $inscriptionlesson)
    {
        $this->inscriptionlessons[] = $inscriptionlesson;

        return $this;
    }

    /**
     * Remove inscriptionlesson
     *
     * @param \AppBundle\Entity\InscriptionLesson $inscriptionlesson
     */
    public function removeInscriptionlesson(\AppBundle\Entity\InscriptionLesson $inscriptionlesson)
    {
        $this->inscriptionlessons->removeElement($inscriptionlesson);
    }

    public function getTotalLessonsWatched()
    {
        $total = 0;
        foreach ($this->inscriptionlessons as $inscriptionlesson) {
            if ($inscriptionlesson->isFinished()) {
                $total++;
            }
        }
        return $total;
    }
}
