<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Type;

/**
 * Class
 *
 * @ORM\Table(name="inscription_class")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\InscriptionClassRepository")
 * @ExclusionPolicy("all")
 */
class InscriptionClass
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Expose
     */
    private $id;

    /**
     * @var Course
     *
     * @ORM\ManyToOne(targetEntity="UserBundle\Entity\User", inversedBy="inscriptionsClass")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=true)
     * @Expose
     */
    private $user;

    /**
     * @var Course
     *
     * @ORM\ManyToOne(targetEntity="CourseClass", inversedBy="inscriptionsClass")
     * @ORM\JoinColumn(name="course_class_id", referencedColumnName="id", nullable=true)
     */
    private $courseClass;

    /**
     * @var integer
     *
     * @ORM\Column(name="grade", type="integer", nullable=true)
     */
    private $grade;

    /**
     * @var string
     *
     * @ORM\Column(name="observation", type="string", length=255, nullable=true)
     * @Expose
     */
    private $observation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_creation", type="datetime")
     * @Gedmo\Timestampable(on="create")
     * @Expose
     */
    private $dtCreation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_update", type="datetime")
     * @Gedmo\Timestampable(on="update")
     * @Expose
     */
    private $dtUpdate;

    /**
     *
     * @ORM\ManyToOne(targetEntity="InscriptionClassStatus")
     * @ORM\JoinColumn(name="inscriptionclass_status_id", referencedColumnName="id")
     */
    private $inscriptionClassStatus;

    public function __construct()
    {
    }

    public function __toString()
    {
        return "ID: ".$this->id;
    }

    /**
     * Set id
     *
     * @param integer $id;
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set user
     *
     * @param User $user
     * @return Class
     */
    public function setUser($user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return Class
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set course
     *
     * @param CourseClass $courseClass
     * @return Class
     */
    public function setCourseClass($courseClass = null)
    {
        $this->courseClass = $courseClass;

        return $this;
    }

    /**
     * Get courseClass
     *
     * @return Class
     */
    public function getCourseClass()
    {
        return $this->courseClass;
    }

    /**
     * Set grade
     *
     * @param Integer $grade
     *
     * @return UserEvaluation
     */
    public function setGrade($grade)
    {
        $this->grade = $grade;

        return $this;
    }

    /**
     * Get grade
     *
     * @return UserEvaluation
     */
    public function getGrade()
    {
        return $this->grade;
    }

    /**
     * Set observation
     *
     * @param string $observation
     * @return Class
     */
    public function setObservation($observation)
    {
        $this->observation = $observation;

        return $this;
    }

    /**
     * Get observation
     *
     * @return string
     */
    public function getObservation()
    {
        return $this->observation;
    }

    /**
     * Set dtCreation
     *
     * @param Inscription $dtCreation
     * @return Class
     */
    public function setDtCreation($dtCreation = null)
    {
        $this->dtCreation = $dtCreation;

        return $this;
    }

    /**
     * Get dtCreation
     *
     * @return Class
     */
    public function getDtCreation()
    {
        return $this->dtCreation;
    }

    /**
     * Set dtUpdate
     *
     * @param Inscription $dtUpdate
     * @return Class
     */
    public function setDtUpdate($dtUpdate = null)
    {
        $this->dtUpdate = $dtUpdate;

        return $this;
    }

    /**
     * Get dtUpdate
     *
     * @return Class
     */
    public function getDtUpdate()
    {
        return $this->dtUpdate;
    }

    /**
     * Set $inscriptionClassStatus
     *
     * @param InscriptionClassStatus $inscriptionClassStatus
     * @return InscriptionClass
     */
    public function setInscriptionClassStatus($inscriptionClassStatus)
    {
        $this->inscriptionClassStatus = $inscriptionClassStatus;

        return $this;
    }

    /**
     * Get inscriptionClassStatus
     *
     * @return InscriptionClassStatus
     */
    public function getInscriptionClassStatus()
    {
        return $this->inscriptionClassStatus;
    }

}
