<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Type;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * InscriptionLesson
 *
 * @ORM\Table(name="inscription_lesson")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\InscriptionLessonRepository")
 * @ExclusionPolicy("all")
 */
class InscriptionLesson
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Expose
     */
    private $id;

    /**
     * @var Inscription
     *
     * @ORM\ManyToOne(targetEntity="Inscription", inversedBy="inscriptionlessons")
     * @ORM\JoinColumn(name="inscription_id", referencedColumnName="id", nullable=false)
     */
    private $inscription;

    /**
     * @var Lesson
     *
     * @ORM\ManyToOne(targetEntity="Lesson", inversedBy="inscriptionlessons")
     * @ORM\JoinColumn(name="lesson_id", referencedColumnName="id", nullable=false)
     */
    private $lesson;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="loaded", type="datetime", nullable=true)
     * @Expose
     */
    private $loaded;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="started", type="datetime", nullable=true)
     * @Expose
     */
    private $started;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="finished", type="datetime", nullable=true)
     * @Expose
     */
    private $finished;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_creation", type="datetime", nullable=true)
     * @Gedmo\Timestampable(on="create")
     * @Expose
     */
    private $dtCreation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_update", type="datetime", nullable=true)
     * @Gedmo\Timestampable(on="update")
     * @Expose
     */
    private $dtUpdate;

    public function __toString()
    {
        return $this->id;
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set loaded
     *
     * @param \DateTime $loaded
     *
     * @return InscriptionLesson
     */
    public function setLoaded($loaded)
    {
        $this->loaded = $loaded;

        return $this;
    }

    /**
     * Get loaded
     *
     * @return \DateTime
     */
    public function getLoaded()
    {
        return $this->loaded;
    }

    /**
     * Set started
     *
     * @param \DateTime $started
     *
     * @return InscriptionLesson
     */
    public function setStarted($started)
    {
        $this->started = $started;

        return $this;
    }

    /**
     * Get started
     *
     * @return \DateTime
     */
    public function getStarted()
    {
        return $this->started;
    }

    /**
     * Set finished
     *
     * @param \DateTime $finished
     *
     * @return InscriptionLesson
     */
    public function setFinished($finished)
    {
        $this->finished = $finished;

        return $this;
    }

    /**
     * Get finished
     *
     * @return \DateTime
     */
    public function getFinished()
    {
        return $this->finished;
    }

    /**
     * Set inscription
     *
     * @param \AppBundle\Entity\Inscription $inscription
     *
     * @return InscriptionLesson
     */
    public function setInscription(\AppBundle\Entity\Inscription $inscription)
    {
        $this->inscription = $inscription;

        return $this;
    }

    /**
     * Get inscription
     *
     * @return \AppBundle\Entity\Inscription
     */
    public function getInscription()
    {
        return $this->inscription;
    }

    /**
     * Set lesson
     *
     * @param \AppBundle\Entity\Lesson $lesson
     *
     * @return InscriptionLesson
     */
    public function setLesson(\AppBundle\Entity\Lesson $lesson)
    {
        $this->lesson = $lesson;

        return $this;
    }

    /**
     * Get lesson
     *
     * @return \AppBundle\Entity\Lesson
     */
    public function getLesson()
    {
        return $this->lesson;
    }

    public function isLoaded() {
        return $this->loaded !== null;
    }

    public function isStarted() {
        return $this->started !== null;
    }

    public function isFinished() {
        return $this->finished !== null;
    }

    /**
     * Set dtCreation
     *
     * @param Inscription $dtCreation
     * @return Class
     */
    public function setDtCreation($dtCreation = null)
    {
        $this->dtCreation = $dtCreation;

        return $this;
    }

    /**
     * Get dtCreation
     *
     * @return Class
     */
    public function getDtCreation()
    {
        return $this->dtCreation;
    }

    /**
     * Set dtUpdate
     *
     * @param Inscription $dtUpdate
     * @return Class
     */
    public function setDtUpdate($dtUpdate = null)
    {
        $this->dtUpdate = $dtUpdate;

        return $this;
    }

    /**
     * Get dtUpdate
     *
     * @return Class
     */
    public function getDtUpdate()
    {
        return $this->dtUpdate;
    }
}
