<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\Expose;

/**
 * IntegracaoParticipacaoPontuada
 *
 * @ORM\Table(name="integracao_participacaopontuada")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\IntegracaoParticipacaoPontuadaRepository")
 */
class IntegracaoParticipacaoPontuada
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="crmCooperado", type="integer")
     */
    private $crmCooperado;

    /**
     * @var string
     *
     * @ORM\Column(name="codigoChaveRegra", type="string", length=255)
     */
    private $codigoChaveRegra;

    /**
     * @var string
     *
     * @ORM\Column(name="codigoOrigem", type="string", length=30)
     */
    private $codigoOrigem;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dataReferencia", type="datetime")
     */
    private $dataReferencia;

    /**
     * @var string
     *
     * @ORM\Column(name="indicadorControleTransacao", type="string", length=1)
     */
    private $indicadorControleTransacao;

    /**
     * @var string
     *
     * @ORM\Column(name="status", type="string", length=1)
     */
    private $status;

    /**
     * @var int
     *
     * @ORM\Column(name="cod_erro", type="integer", nullable=true)
     */
    private $codErro;

    /**
     * @var string
     *
     * @ORM\Column(name="msg_retorno", type="string", length=255, nullable=true)
     */
    private $msgRetorno;

    /**
     * @var string
     *
     * @ORM\Column(name="parameter_sent", type="string", length=255, nullable=true)
     */
    private $parameterSent;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_creation", type="datetime")
     * @Gedmo\Timestampable(on="create")
     * @Expose
     */
    private $dateInsert;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_update", type="datetime")
     * @Gedmo\Timestampable(on="update")
     * @Expose
     */
    private $dateUpdate;

    /**
     * @var Course
     *
     * @ORM\ManyToOne(targetEntity="Course")
     * @ORM\JoinColumn(name="course_id", referencedColumnName="id", nullable=true)
     */
    private $course;

    /**
     * @var Client
     *
     * @ORM\ManyToOne(targetEntity="Client")
     * @ORM\JoinColumn(name="client_id", referencedColumnName="id", nullable=true)
     */
    private $client;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set crmCooperado
     *
     * @param integer $crmCooperado
     *
     * @return IntegracaoParticipacaoPontuada
     */
    public function setCrmCooperado($crmCooperado)
    {
        $this->crmCooperado = $crmCooperado;

        return $this;
    }

    /**
     * Get crmCooperado
     *
     * @return integer
     */
    public function getCrmCooperado()
    {
        return $this->crmCooperado;
    }

    /**
     * Set codigoChaveRegra
     *
     * @param string $codigoChaveRegra
     *
     * @return IntegracaoParticipacaoPontuada
     */
    public function setCodigoChaveRegra($codigoChaveRegra)
    {
        $this->codigoChaveRegra = $codigoChaveRegra;

        return $this;
    }

    /**
     * Get codigoChaveRegra
     *
     * @return string
     */
    public function getCodigoChaveRegra()
    {
        return $this->codigoChaveRegra;
    }

    /**
     * Set codigoOrigem
     *
     * @param string $codigoOrigem
     *
     * @return IntegracaoParticipacaoPontuada
     */
    public function setCodigoOrigem($codigoOrigem)
    {
        $this->codigoOrigem = $codigoOrigem;

        return $this;
    }

    /**
     * Get codigoOrigem
     *
     * @return string
     */
    public function getCodigoOrigem()
    {
        return $this->codigoOrigem;
    }

    /**
     * Set dataReferencia
     *
     * @param \DateTime $dataReferencia
     *
     * @return IntegracaoParticipacaoPontuada
     */
    public function setDataReferencia($dataReferencia)
    {
        $this->dataReferencia = $dataReferencia;

        return $this;
    }

    /**
     * Get dataReferencia
     *
     * @return \DateTime
     */
    public function getDataReferencia()
    {
        return $this->dataReferencia;
    }

    /**
     * Set indicadorControleTransacao
     *
     * @param string $indicadorControleTransacao
     *
     * @return IntegracaoParticipacaoPontuada
     */
    public function setIndicadorControleTransacao($indicadorControleTransacao)
    {
        $this->indicadorControleTransacao = $indicadorControleTransacao;

        return $this;
    }

    /**
     * Get indicadorControleTransacao
     *
     * @return string
     */
    public function getIndicadorControleTransacao()
    {
        return $this->indicadorControleTransacao;
    }

    /**
     * Set status
     *
     * @param string $status
     *
     * @return IntegracaoParticipacaoPontuada
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set codErro
     *
     * @param integer $codErro
     *
     * @return IntegracaoParticipacaoPontuada
     */
    public function setCodErro($codErro)
    {
        $this->codErro = $codErro;

        return $this;
    }

    /**
     * Get codErro
     *
     * @return integer
     */
    public function getCodErro()
    {
        return $this->codErro;
    }

    /**
     * Set msgRetorno
     *
     * @param string $msgRetorno
     *
     * @return IntegracaoParticipacaoPontuada
     */
    public function setMsgRetorno($msgRetorno)
    {
        $this->msgRetorno = $msgRetorno;

        return $this;
    }

    /**
     * Get msgRetorno
     *
     * @return string
     */
    public function getMsgRetorno()
    {
        return $this->msgRetorno;
    }

    /**
     * Set parameterSent
     *
     * @param string $parameterSent
     *
     * @return IntegracaoParticipacaoPontuada
     */
    public function setParameterSent($parameterSent)
    {
        $this->parameterSent = $parameterSent;

        return $this;
    }

    /**
     * Get parameterSent
     *
     * @return string
     */
    public function getParameterSent()
    {
        return $this->parameterSent;
    }

    /**
     * Set dateInsert
     *
     * @param \DateTime $dateInsert
     *
     * @return IntegracaoParticipacaoPontuada
     */
    public function setDateInsert($dateInsert)
    {
        $this->dateInsert = $dateInsert;

        return $this;
    }

    /**
     * Get dateInsert
     *
     * @return \DateTime
     */
    public function getDateInsert()
    {
        return $this->dateInsert;
    }

    /**
     * Set dateUpdate
     *
     * @param \DateTime $dateUpdate
     *
     * @return IntegracaoParticipacaoPontuada
     */
    public function setDateUpdate($dateUpdate)
    {
        $this->dateUpdate = $dateUpdate;

        return $this;
    }

    /**
     * Get dateUpdate
     *
     * @return \DateTime
     */
    public function getDateUpdate()
    {
        return $this->dateUpdate;
    }

    /**
     * Set course
     *
     * @param \AppBundle\Entity\Course $course
     *
     * @return IntegracaoParticipacaoPontuada
     */
    public function setCourse(\AppBundle\Entity\Course $course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course
     *
     * @return \AppBundle\Entity\Course
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set client
     *
     * @param Client $client
     *
     * @return IntegracaoParticipacaoPontuada
     */
    public function setClient(Client $client = null)
    {
        $this->client = $client;

        return $this;
    }

    /**
     * Get client
     *
     * @return Client
     */
    public function getClient()
    {
        return $this->client;
    }
}
