<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\Expose;

/**
 * IntegrationReturn
 *
 * @ORM\Table(name="integration_return")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\IntegrationReturnRepository")
 */
class IntegrationReturn
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_conclusion", type="datetime", nullable=true)
     */
    private $dateConclusion;

    /**
     * @var string
     *
     * @ORM\Column(name="status", type="string", length=1, nullable=true)
     */
    private $status;

    /**
     * @var int
     *
     * @ORM\Column(name="cod_erro", type="integer", nullable=true)
     */
    private $codErro;

    /**
     * @var string
     *
     * @ORM\Column(name="msg_return", type="string", length=255, nullable=true)
     */
    private $msgReturn;

    /**
     * @var string
     *
     * @ORM\Column(name="parameter_sent", type="string", length=255, nullable=true)
     */
    private $parameterSent;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_creation", type="datetime")
     * @Gedmo\Timestampable(on="create")
     * @Expose
     */
    private $dateInsert;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_update", type="datetime")
     * @Gedmo\Timestampable(on="update")
     * @Expose
     */
    private $dateUpdate;

    /**
     * @var Course
     *
     * @ORM\ManyToOne(targetEntity="Course")
     * @ORM\JoinColumn(name="course_id", referencedColumnName="id", nullable=true)
     */
    private $course;

    /**
     * @var Course
     *
     * @ORM\ManyToOne(targetEntity="UserBundle\Entity\User")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=true)
     */
    private $user;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set dateConclusion
     *
     * @param \DateTime $dateConclusion
     *
     * @return IntegrationReturn
     */
    public function setDateConclusion($dateConclusion)
    {
        $this->dateConclusion = $dateConclusion;

        return $this;
    }

    /**
     * Get dateConclusion
     *
     * @return \DateTime
     */
    public function getDateConclusion()
    {
        return $this->dateConclusion;
    }

    /**
     * Set status
     *
     * @param string $status
     *
     * @return IntegrationReturn
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set codErro
     *
     * @param integer $codErro
     *
     * @return IntegrationReturn
     */
    public function setCodErro($codErro)
    {
        $this->codErro = $codErro;

        return $this;
    }

    /**
     * Get codErro
     *
     * @return integer
     */
    public function getCodErro()
    {
        return $this->codErro;
    }

    /**
     * Set msgReturn
     *
     * @param string $msgReturn
     *
     * @return IntegrationReturn
     */
    public function setMsgReturn($msgReturn)
    {
        $this->msgReturn = $msgReturn;

        return $this;
    }

    /**
     * Get msgReturn
     *
     * @return string
     */
    public function getMsgReturn()
    {
        return $this->msgReturn;
    }

    /**
     * Set parameterSent
     *
     * @param string $parameterSent
     *
     * @return IntegrationReturn
     */
    public function setParameterSent($parameterSent)
    {
        $this->parameterSent = $parameterSent;

        return $this;
    }

    /**
     * Get parameterSent
     *
     * @return string
     */
    public function getParameterSent()
    {
        return $this->parameterSent;
    }

    /**
     * Set dateInsert
     *
     * @param \DateTime $dateInsert
     *
     * @return IntegrationReturn
     */
    public function setDateInsert($dateInsert)
    {
        $this->dateInsert = $dateInsert;

        return $this;
    }

    /**
     * Get dateInsert
     *
     * @return \DateTime
     */
    public function getDateInsert()
    {
        return $this->dateInsert;
    }

    /**
     * Set dateUpdate
     *
     * @param \DateTime $dateUpdate
     *
     * @return IntegrationReturn
     */
    public function setDateUpdate($dateUpdate)
    {
        $this->dateUpdate = $dateUpdate;

        return $this;
    }

    /**
     * Get dateUpdate
     *
     * @return \DateTime
     */
    public function getDateUpdate()
    {
        return $this->dateUpdate;
    }

    /**
     * Set course
     *
     * @param \AppBundle\Entity\Course $course
     *
     * @return IntegrationReturn
     */
    public function setCourse(\AppBundle\Entity\Course $course = null)
    {
        $this->course = $course;

        return $this;
    }

    /**
     * Get course
     *
     * @return \AppBundle\Entity\Course
     */
    public function getCourse()
    {
        return $this->course;
    }

    /**
     * Set user
     *
     * @param \UserBundle\Entity\User $user
     *
     * @return IntegrationReturn
     */
    public function setUser(\UserBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \UserBundle\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }
}
