<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Type;

/**
 * Class
 *
 * @ORM\Table(name="iqa_log")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\IqaLogRepository")
 * @ExclusionPolicy("all")
 */
class IqaLog
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Expose
     */
    private $id;

        /**
    * @var IqaCicle
    *
    * @ORM\ManyToOne(targetEntity="IqaCicle")
    * @ORM\JoinColumn(name="iqa_cicle_id", referencedColumnName="id", onDelete="CASCADE", nullable=true)
    */
    private $iqaCicle;

    /**
     * @var string
     *
     * @ORM\Column(name="message", type="string", length=500)
     */
    private $message;

    /**
     * @var string
     *
     * @ORM\Column(name="porcentagem", type="string", length=255)
     */
    private $porcentagem;

    /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="UserBundle\Entity\User")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=true)
     * @Expose
     */
    private $user;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created_at", type="datetime")
     * @Gedmo\Timestampable(on="create")
     * @Expose
     */
    private $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updated_at", type="datetime")
     * @Gedmo\Timestampable(on="update")
     * @Expose
     */
    private $updatedAt;

    public function __toString()
    {
        return $this->id;
    }

    /**
     * Set id
     *
     * @param integer $id;
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set iqaCicle
     *
     * @param integer $iqaCicle;
     */
    public function setIqaCicle($iqaCicle)
    {
        $this->iqaCicle = $iqaCicle;
    }

    /**
     * Get message
     *
     * @return integer
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * Set message
     *
     * @param integer $message;
     */
    public function setMessage($message)
    {
        $this->message = $message;
    }

    /**
     * Get porcentagem
     *
     * @return integer
     */
    public function getPorcentagem()
    {
        return $this->porcentagem;
    }

    /**
     * Set porcentagem
     *
     * @param integer $porcentagem;
     */
    public function setPorcentagem($porcentagem)
    {
        $this->porcentagem = $porcentagem;
    }

    /**
     * Set user
     *
     * @param User $user
     * @return IqaCicleConcluded
     */
    public function setUser($user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return Class
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Get iqaCicle
     *
     * @return integer
     */
    public function getIqaCicle()
    {
        return $this->iqaCicle;
    }

    /**
     * Set createdAt
     *
     * @param \DateTime $createdAt
     *
     * @return Payment
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Set updatedAt
     *
     * @param \DateTime $updatedAt
     *
     * @return Payment
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

}
