<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Type;

/**
 * Class
 *
 * @ORM\Table(name="iqa_midia")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\IqaMidiaRepository")
 * @ExclusionPolicy("all")
 */
class IqaMidia
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Expose
     */
    private $id;

    /**
    * @var IqaCicle
    *
    * @ORM\ManyToOne(targetEntity="IqaCicle")
    * @ORM\JoinColumn(name="iqa_cicle_id", referencedColumnName="id", onDelete="CASCADE", nullable=true)
    */
    private $iqaCicle;

    /**
    * @var MediaType
    *
    * @ORM\ManyToOne(targetEntity="MediaType")
    * @ORM\JoinColumn(name="media_type_id", referencedColumnName="id", onDelete="CASCADE", nullable=true)
    */
    private $mediaType;

    /**
     * @var string
     *
     * @ORM\Column(name="media_name", type="string", length=255)
     */
    private $mediaName;
    
    /**
     * @var string
     *
     * @ORM\Column(name="media_id", type="integer", nullable=true)
     */
    private $mediaId;

    /**
     * @var string
     *
     * @ORM\Column(name="course_id", type="integer", nullable=true)
     */
    private $courseId;

    /**
     * @var string
     *
     * @ORM\Column(name="plataform", type="string", length=255)
     */
    private $plataform;

    /**
     * @var integer
     *
     * @ORM\Column(name="percentage", type="integer", nullable=true)
     */
    private $percentage;

    /**
     * @var string
     *
     * @ORM\Column(name="mandatory", type="boolean")
     */
    private $mandatory;

    /**
     * Transient field
     */
    private $midiaIdTemp;
    private $midiaTypeTemp;


    public function __toString()
    {
        return $this->id;
    }

    /**
     * Set id
     *
     * @param integer $id;
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set iqaCicle
     *
     * @param integer $iqaCicle;
     */
    public function setIqaCicle($iqaCicle)
    {
        $this->iqaCicle = $iqaCicle;
    }

    /**
     * Get iqaCicle
     *
     * @return integer
     */
    public function getIqaCicle()
    {
        return $this->iqaCicle;
    }

    /**
     * Set mediaType
     *
     * @param integer $mediaType;
     */
    public function setMediaType($mediaType)
    {
        $this->mediaType = $mediaType;
    }

    /**
     * Get mediaType
     *
     * @return integer
     */
    public function getMediaType()
    {
        return $this->mediaType;
    }

    /**
     * Set mediaName
     *
     * @param String $mediaName;
     */
    public function setMediaName($mediaName)
    {
        $this->mediaName = $mediaName;
    }

    /**
     * Get mediaName
     *
     * @return String
     */
    public function getMediaName()
    {
        return $this->mediaName;
    }

    /**
     * Set mediaId
     *
     * @param integer $mediaId;
     */
    public function setMediaId($mediaId)
    {
        $this->mediaId = $mediaId;
    }

    /**
     * Get mediaId
     *
     * @return integer
     */
    public function getMediaId()
    {
        return $this->mediaId;
    }

    /**
     * Set courseId
     *
     * @param integer $courseId;
     */
    public function setCourseId($courseId)
    {
        $this->courseId = $courseId;
    }

    /**
     * Get courseId
     *
     * @return integer
     */
    public function getCourseId()
    {
        return $this->courseId;
    }

    /**
     * Set plataform
     *
     * @param String $plataform;
     */
    public function setPlataform($plataform)
    {
        $this->plataform = $plataform;
    }

    /**
     * Get plataform
     *
     * @return String
     */
    public function getPlataform()
    {
        return $this->plataform;
    }

    /**
     * Set percentage
     *
     * @param \Integer $percentage
     *
     * @return IqaMidia
     */
    public function setPercentage($percentage)
    {
        $this->percentage = $percentage;

        return $this;
    }

    /**
     * Get percentage
     *
     * @return \Integer
     */
    public function getPercentage()
    {
        return $this->percentage;
    }

    /**
     * Set mandatory
     *
     * @param boolean $mandatory
     *
     * @return IqaMidia
     */
    public function setMandatory($mandatory)
    {
        $this->mandatory = $mandatory;

        return $this;
    }

    /**
     * Get mandatory
     *
     * @return boolean
     */
    public function getMandatory()
    {
        return $this->mandatory;
    }

    /**
     * Set midiaIdTemp
     *
     * @param Integer $midiaIdTemp
     *
     * @return IqaMidia
     */
    public function setMidiaIdTemp($midiaIdTemp)
    {
        $this->midiaIdTemp = $midiaIdTemp;

        return $this;
    }

    /**
     * Get midiaIdTemp
     *
     * @return boolean
     */
    public function getMidiaIdTemp()
    {
        return $this->midiaIdTemp;
    }

    /**
     * Set midiaTypeTemp
     *
     * @param Integer $midiaTypeTemp
     *
     * @return IqaMidia
     */
    public function setMidiaTypeTemp($midiaTypeTemp)
    {
        $this->midiaTypeTemp = $midiaTypeTemp;

        return $this;
    }

    /**
     * Get midiaTypeTemp
     *
     * @return boolean
     */
    public function getMidiaTypeTemp()
    {
        return $this->midiaTypeTemp;
    }
}
