<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Type;

/**
 * Class
 *
 * @ORM\Table(name="learning_trail")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\LearningTrailRepository")
 * @ORM\HasLifecycleCallbacks()
 * @ExclusionPolicy("all")
 */
class LearningTrail
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Expose
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=true)
     * @Expose
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="cover", type="string", length=255, nullable=true)
     */
    private $cover;

    /**
     * @var string
     *
     * @ORM\Column(name="courses", type="text", nullable=true)
     * @Expose
     */
    private $courses;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_creation", type="datetime")
     * @Gedmo\Timestampable(on="create")
     * @Expose
     */
    private $dtCreation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_update", type="datetime")
     * @Gedmo\Timestampable(on="update")
     * @Expose
     */
    private $dtUpdate;

    /**
     * @var string
     *
     * @ORM\Column(name="dependency", type="boolean", nullable=true)
     */
    private $dependency;

    /**
     * @var string
     *
     * @ORM\Column(name="public", type="boolean", nullable=true)
     */
    private $public;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="text", nullable=true)
     * @Expose
     */
    private $description;

    /**
     * @ORM\OneToMany(targetEntity="ManagementLearningTrail", mappedBy="learningTrail", cascade={"all"}, orphanRemoval=true)
     */
    private $managementLearningTrail;

    /**
     * @ORM\OneToMany(targetEntity="ClientLearningTrail", mappedBy="learningTrail", cascade={"all"}, orphanRemoval=true)
     */
    private $clientLearningTrail;

    /**
     * @var string
     *
     * @ORM\Column(name="num_enterprise", type="integer", nullable=true)
     */
    protected $numEmp;

    /**
     * One Banner has One LearningTrailFilter.
     * @ORM\OneToOne(targetEntity="LearningTrailFilter", mappedBy="learningTrail")
     */
    private $learningTrailFilter;

    /**
     * __toString method
     */
    public function __toString() {
        return $this->getName();
    }

    public function __construct()
    {
        $this->managementLearningTrail = new \Doctrine\Common\Collections\ArrayCollection();
        $this->clientLearningTrail = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Set id
     *
     * @param integer $id;
     */
    public function setId($id) {
        $this->id = $id;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return LearningTrail
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set cover
     *
     * @param string $cover
     *
     * @return LearningTrail
     */
    public function setCover($cover)
    {
        $this->cover = $cover;

        return $this;
    }

    /**
     * Get cover
     *
     * @return string
     */
    public function getCover()
    {
        return $this->cover;
    }

    /**
     * Set courses
     *
     * @param string $courses
     * @return LearningTrail
     */
    public function setCourses($courses)
    {
        $this->courses = $courses;

        return $this;
    }

    /**
     * Get courses
     *
     * @return string
     */
    public function getCourses()
    {
        return $this->courses;
    }

    /**
     * Set dtCreation
     *
     * @param \DateTime $dtCreation
     *
     * @return LearningTrail
     */
    public function setDtCreation($dtCreation)
    {
        $this->dtCreation = $dtCreation;

        return $this;
    }

    /**
     * Get dtCreation
     *
     * @return \DateTime
     */
    public function getDtCreation()
    {
        return $this->dtCreation;
    }

    /**
     * Set dtUpdate
     *
     * @param \DateTime $dtUpdate
     *
     * @return LearningTrail
     */
    public function setDtUpdate($dtUpdate)
    {
        $this->dtUpdate = $dtUpdate;

        return $this;
    }

    /**
     * Get dtUpdate
     *
     * @return \DateTime
     */
    public function getDtUpdate()
    {
        return $this->dtUpdate;
    }

    /**
     * Set dependency
     *
     * @param boolean $dependency
     *
     * @return LearningTrail
     */
    public function setDependency($dependency)
    {
        $this->dependency = $dependency;

        return $this;
    }

    /**
     * Get dependency
     *
     * @return boolean
     */
    public function getDependency()
    {
        return $this->dependency;
    }

    /**
     * Set public
     *
     * @param boolean $public
     *
     * @return LearningTrail
     */
    public function setPublic($public)
    {
        $this->public = $public;

        return $this;
    }

    /**
     * Get public
     *
     * @return boolean
     */
    public function getPublic()
    {
        return $this->public;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return Course
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    const UPLOAD_PATH_LEARNINGTRAIL_COVER = 'uploads/learning-trail/cover';

    /**
     * @Assert\File(
     *     maxSize = "3072k",
     *     maxSizeMessage = "O tamanho da imagem é muito grande ({{ size }} {{ suffix }}), escolha uma imagem de até {{ limit }} {{ suffix }}",
     *     mimeTypes = {"image/jpeg", "image/gif", "image/png"},
     *     mimeTypesMessage = "Formato de arquivo inválido. Formatos permitidos: .gif, .jpeg e .png"
     * )
     */
    private $coverTemp;

    /**
     * Sets coverTemp
     *
     * @param UploadedFile $coverTemp
     */
    public function setCoverTemp(UploadedFile $coverTemp = null)
    {
        $this->coverTemp = $coverTemp;
    }

    /**
     * Get coverTemp
     *
     * @return UploadedFile
     */
    public function getCoverTemp()
    {
        return $this->coverTemp;
    }

    /**
     * Lifecycle callback to upload the file to the server
     * @ORM\PrePersist
     * @ORM\PreUpdate
     */
    public function lifecycleFileUpload() {
        $this->uploadImage();
    }

    /**
     * @ORM\PostLoad()
     */
    public function postLoad()
    {
        $this->dtUpdate = new \DateTime();
    }

    /**
     * Unlink Photo (Apagar foto quando excluir objeto)
     */
    public function unlinkImages()
    {

        if ($this->getCover() != null) {
            unlink(LearningTrail::UPLOAD_PATH_LEARNINGTRAIL_COVER ."/". $this->getCover());
        }
    }

    /**
     * Manages the copying of the file to the relevant place on the server
     */
    public function uploadImage()
    {

        //Upload de cover
        if($this->getCoverTemp()!=null){
          //Se o diretorio não existir, cria
          if (!file_exists(LearningTrail::UPLOAD_PATH_LEARNINGTRAIL_COVER)) {
              mkdir(LearningTrail::UPLOAD_PATH_LEARNINGTRAIL_COVER, 0755, true);
          }
          if(
              ($this->getCoverTemp() != $this->getCover())
              && (null !== $this->getCover())
          ){
              unlink(LearningTrail::UPLOAD_PATH_LEARNINGTRAIL_COVER ."/". $this->getCover());
          }

          // Generate a unique name for the file before saving it
          $fileName = md5(uniqid()).'.'.$this->getCoverTemp()->guessExtension();

          UploadService::compress($this->getCoverTemp(), LearningTrail::UPLOAD_PATH_LEARNINGTRAIL_COVER."/".$fileName, 100);

          // set the path property to the filename where you've saved the file
          $this->cover = $fileName;

          // clean up the file property as you won't need it anymore
          $this->setCoverTemp(null);
        }

    }

    /**
     * Add managementLearningTrail
     *
     * @param \AppBundle\Entity\ManagementLearningTrail $managementLearningTrail
     *
     * @return Videos
     */
     public function addManagementLearningTrail(ManagementLearningTrail $managementLearningTrail)
     {
         $managementLearningTrail->setLearningTrail($this);

         $this->managementLearningTrail->add($managementLearningTrail);
     }

    /**
     * Remove ManagementLearningTrail
     *
     * @param \AppBundle\Entity\ManagementLearningTrail $managementLearningTrail
     */
    public function removeManagementLearningTrail(\AppBundle\Entity\ManagementLearningTrail $managementLearningTrail)
    {
        $this->managementLearningTrail->removeElement($managementLearningTrail);
    }

    /**
     * Set ManagementLearningTrail
     *
     * @param ManagementLearningTrail $managementLearningTrail
     * @return ManagementLearningTrail
     */
    public function setManagementLearningTrail($managementLearningTrail = null)
    {
        $this->managementLearningTrail = $managementLearningTrail;

        return $this;
    }

    /**
     * Get ManagementLearningTrail
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getManagementLearningTrail()
    {
        return $this->managementLearningTrail;
    }

    /**
     * Set ClientLearningTrail
     *
     * @param ClientLearningTrail $clientLearningTrail
     * @return ClientLearningTrail
     */
    public function setClientLearningTrail($clientLearningTrail = null)
    {
        $this->clientLearningTrail = $clientLearningTrail;

        return $this;
    }

    /**
     * Get ClientLearningTrail
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getClientLearningTrail()
    {
        return $this->clientLearningTrail;
    }

    /**
     * Set numEmp
     *
     * @param integer $numEmp
     *
     * @return Banner
     */
    public function setNumEmp($numEmp)
    {
        $this->numEmp = $numEmp;

        return $this;
    }

    /**
     * Get numEmp
     *
     * @return integer
     */
    public function getNumEmp()
    {
        return $this->numEmp;
    }

    /**
     * Set learningTrailFilter
     *
     * @param \AppBundle\Entity\LearningTrailFilter $learningTrailFilter
     *
     * @return Banner
     */
    public function setLearningTrailFilter(\AppBundle\Entity\LearningTrailFilter $learningTrailFilter = null)
    {
        $this->learningTrailFilter = $learningTrailFilter;

        return $this;
    }

    /**
     * Get learningTrailFilter
     *
     * @return \AppBundle\Entity\LearningTrailFilter
     */
    public function getLearningTrailFilter()
    {
        return $this->learningTrailFilter;
    }

}
