<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Type;

/**
 * LearningTrailFilter
 *
 * @ORM\Table(name="learning_trail_filter")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\LearningTrailFilterRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class LearningTrailFilter
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * One Cart has One Customer.
     * @ORM\OneToOne(targetEntity="LearningTrail", inversedBy="learningTrailFilter")
     * @ORM\JoinColumn(name="learningTrail_id", referencedColumnName="id", onDelete="CASCADE")
     */
    private $learningTrail;

    /**
     * @var string
     *
     * @ORM\Column(name="sectors", type="text", nullable=true)
     * @Expose
     */
    private $sectors;

    /**
     * @var string
     *
     * @ORM\Column(name="job_roles", type="text", nullable=true)
     * @Expose
     */
    private $jobRoles;

    /**
     * @var string
     *
     * @ORM\Column(name="managements", type="text", nullable=true)
     * @Expose
     */
    private $managements;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set sectors
     *
     * @param string $sectors
     *
     * @return LearningTrailFilter
     */
    public function setSectors($sectors)
    {
        $this->sectors = $sectors;

        return $this;
    }

    /**
     * Get sectors
     *
     * @return string
     */
    public function getSectors()
    {
        return json_decode($this->sectors);
    }

    /**
     * Set jobRoles
     *
     * @param string $jobRoles
     *
     * @return LearningTrailFilter
     */
    public function setJobRoles($jobRoles)
    {
        $this->jobRoles = $jobRoles;

        return $this;
    }

    /**
     * Get jobRoles
     *
     * @return string
     */
    public function getJobRoles()
    {
        return json_decode($this->jobRoles);
    }

    /**
     * Set managements
     *
     * @param string $managements
     *
     * @return LearningTrailFilter
     */
    public function setManagements($managements)
    {
        $this->managements = $managements;

        return $this;
    }

    /**
     * Get managements
     *
     * @return string
     */
    public function getManagements()
    {
        return json_decode($this->managements);
    }

    /**
     * Set learningTrail
     *
     * @param $learningTrail
     *
     * @return LearningTrailFilter
     */
    public function setLearningTrail($learningTrail)
    {
        $this->learningTrail = $learningTrail;

        return $this;
    }

    /**
     * Get learningTrail
     *
     * @return 
     */
    public function getLearningTrail()
    {
        return $this->learningTrail;
    }
}
