<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Class
 *
 * @ORM\Table(name="lesson")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\LessonRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class Lesson
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="text", nullable=true)
     */
    private $description;
    /**
     * @var string
     *
     * @ORM\Column(name="sv_video", type="string", length=255, nullable=true)
     */
    private $sv_video;

    /**
     * @var integer
     *
     * @ORM\Column(name="position", type="integer", nullable=true)
     */
    private $position;

    /**
     * @var Module
     *
     * @ORM\ManyToOne(targetEntity="Module", inversedBy="lessons")
     * @ORM\JoinColumn(name="module_id", referencedColumnName="id", nullable=true)
     */
    private $module;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_creation", type="datetime")
     * @Gedmo\Timestampable(on="create")
     */
    private $dtCreation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_update", type="datetime")
     * @Gedmo\Timestampable(on="update")
     */
    private $dtUpdate;

    /**
     * @ORM\OneToMany(targetEntity="Comment", mappedBy="lesson", cascade={"all"})
     */
    protected $comments;

    /**
     * Variável transiente representando a matrícula da aula sendo assistida.
     */
    private $inscriptionLesson;

    /**
     * @var Lesson
     *
     * @ORM\OneToMany(targetEntity="InscriptionLesson", mappedBy="lesson", cascade=
     * {"all"})
    *
     */
    private $inscriptionlessons;


    /**
     * @var Lesson
     *
     * @ORM\OneToMany(targetEntity="LessonFiles", mappedBy="lesson", cascade={"all"})
     *
     */
    private $lessonFiles;

    /**
     * @var Lesson
     *
     * @ORM\OneToMany(targetEntity="Scorm12Sco", mappedBy="lesson", cascade={"all"})
     *
     */
    private $scos;

    /**
     * @var string
     *
     * @ORM\Column(name="cover", type="string", length=255, nullable=true)
     */
    private $cover;

    /**
     * @var string
     *
     * @ORM\Column(name="scorm_file", type="text", nullable=true)
     */
    private $scormFile;

    /**
     * @var string
     *
     * @ORM\Column(name="flash", type="boolean", nullable=true)
     */
    private $flash;

    public function __construct()
    {
        $this->comments = new ArrayCollection();
        $this->inscriptionlessons = new ArrayCollection();
        $this->lessonFiles = new ArrayCollection();
        $this->scos = new ArrayCollection();
    }

    /**
     * Set id
     *
     * @param integer $id;
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Lesson
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return Lesson
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set sv_video
     *
     * @param string $sv_video
     * @return Class
     */
    public function setSvVideo($sv_video)
    {
        $this->sv_video = $sv_video;

        return $this;
    }

    /**
     * Get sv_video
     *
     * @return string
     */
    public function getSvVideo()
    {
        return $this->sv_video;
    }

    /**
     * Set position
     *
     * @param integer $position
     * @return Class
     */
    public function setPosition($position)
    {
        $this->position = $position;

        return $this;
    }

    /**
     * Get position
     *
     * @return integer
     */
    public function getPosition()
    {
        return $this->position;
    }

    /**
     * Set module
     *
     * @param Module $module
     * @return Class
     */
    public function setModule($module = null)
    {
        $this->module = $module;

        return $this;
    }

    /**
     * Get module
     *
     * @return Class
     */
    public function getModule()
    {
        return $this->module;
    }

    /**
     * Set dtCreation
     *
     * @param \DateTime $dtCreation
     *
     * @return Payment
     */
    public function setDtCreation($dtCreation)
    {
        $this->dtCreation = $dtCreation;

        return $this;
    }

    /**
     * Get dtCreation
     *
     * @return \DateTime
     */
    public function getDtCreation()
    {
        return $this->dtCreation;
    }

    /**
     * Set dtUpdate
     *
     * @param \DateTime $dtUpdate
     *
     * @return Payment
     */
    public function setDtUpdate($dtUpdate)
    {
        $this->dtUpdate = $dtUpdate;

        return $this;
    }

    /**
     * Get dtUpdate
     *
     * @return \DateTime
     */
    public function getDtUpdate()
    {
        return $this->dtUpdate;
    }

    /**
     * Set comments
     *
     * @param Comments $comments
     * @return Class
     */
    public function setComments($comments = null)
    {
        $this->comments = $comments;

        return $this;
    }

    /**
     * Get comments
     *
     * @return Class
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set inscriptionlessons
     *
     * @param inscriptionlessons $inscriptionlessons
     * @return Class
     */
    public function setInscriptionlessons($inscriptionlessons = null)
    {
        $this->inscriptionlessons = $inscriptionlessons;

        return $this;
    }

    /**
     * Get inscriptionlessons
     *
     * @return Class
     */
    public function getInscriptionlessons()
    {
        return $this->inscriptionlessons;
    }

    /**
     * Set lessonFiles
     *
     * @param lessonFiles $lessonFiles
     * @return Class
     */
    public function setLessonFiles($lessonFiles = null)
    {
        $this->lessonFiles = $lessonFiles;

        return $this;
    }

    /**
     * Get lessonFiles
     *
     * @return Class
     */
    public function getLessonFiles()
    {
        return $this->lessonFiles;
    }

    /**
     * Set inscriptionLesson
     * @param $inscriptionLesson
     */
    public function setInscriptionLesson($inscriptionLesson = null)
    {
        $this->inscriptionLesson = $inscriptionLesson;
        return $this;
    }

    /**
     * Get inscriptionLesson
     */
    public function getInscriptionLesson()
    {
        return $this->inscriptionLesson;
    }

    /**
     * Set cover
     *
     * @param string $cover
     *
     * @return Course
     */
    public function setCover($cover)
    {
        $this->cover = $cover;

        return $this;
    }

    /**
     * Get cover
     *
     * @return string
     */
    public function getCover()
    {
        return $this->cover;
    }

    /**
     * Set scormFile
     *
     * @param string $scormFile
     * @return Course
     */
    public function setScormFile($scormFile)
    {
        $this->scormFile = $scormFile;

        return $this;
    }

    /**
     * Get scormFile
     *
     * @return string
     */
    public function getScormFile()
    {
        return $this->scormFile;
    }

    public function getScos()
    {
        return $this->scos;
    }

    /**
     * Set flash
     *
     * @param boolean $flash
     *
     * @return Course
     */
    public function setFlash($flash)
    {
        $this->flash = $flash;

        return $this;
    }

    /**
     * Get flash
     *
     * @return boolean
     */
    public function getFlash()
    {
        return $this->flash;
    }

    const UPLOAD_PATH_LESSON_FILES = 'uploads/lesson/files';
    const UPLOAD_PATH_LESSON_COVER = 'uploads/lesson/cover';
    const UPLOAD_PATH_LESSON_SCORM = 'uploads/lesson/scorm';

    public function getPathFileLessonFiles()
    {
        return Lesson::UPLOAD_PATH_LESSON_FILES;
    }

    public function getPathFileLessonCover()
    {
        return Lesson::UPLOAD_PATH_LESSON_COVER;
    }

    public function getPathFileLessonScorm()
    {
        return Lesson::UPLOAD_PATH_LESSON_SCORM;
    }

    /**
     * @Assert\File(
     *     maxSize = "3072k",
     *     maxSizeMessage = "O tamanho da imagem é muito grande ({{ size }} {{ suffix }}), escolha uma imagem de até {{ limit }} {{ suffix }}",
     *     mimeTypes = {"image/jpeg", "image/gif", "image/png"},
     *     mimeTypesMessage = "Formato de arquivo inválido. Formatos permitidos: .gif, .jpeg e .png"
     * )
     */
    private $coverTemp;

    private $scormFileTemp;

    /**
     * Sets coverTemp
     *
     * @param UploadedFile $coverTemp
     */
    public function setCoverTemp(UploadedFile $coverTemp = null)
    {
        $this->coverTemp = $coverTemp;
    }

    /**
     * Get coverTemp
     *
     * @return UploadedFile
     */
    public function getCoverTemp()
    {
        return $this->coverTemp;
    }

    /**
     * Sets scormFileTemp
     *
     * @param UploadedFile $scormFileTemp
     */
    public function setScormFileTemp(UploadedFile $scormFileTemp = null)
    {
        $this->scormFileTemp = $scormFileTemp;
    }

    /**
     * Get scormFileTemp
     *
     * @return UploadedFile
     */
    public function getScormFileTemp()
    {
        return $this->scormFileTemp;
    }

    /**
     * Lifecycle callback to upload the file to the server
     * @ORM\PrePersist
     * @ORM\PreUpdate
     */
    public function lifecycleFileUpload()
    {
        $this->uploadFile();
    }

    /**
     * @ORM\PostLoad()
     */
    public function postLoad()
    {
        $this->dtUpdate = new \DateTime();
    }

    /**
     * Unlink Arquivos (Apagar arquivos quando excluir objeto)
     */
    public function unlinkFiles()
    {
        if ($this->getCover() != null) {
            if (file_exists(Lesson::UPLOAD_PATH_LESSON_COVER ."/". $this->getCover())) {
                unlink(Lesson::UPLOAD_PATH_LESSON_COVER ."/". $this->getCover());
            }
        }
        if ($this->getScormFile() != null) {
            if (file_exists(Lesson::UPLOAD_PATH_LESSON_SCORM ."/". $this->getScormFile())) {
                unlink(Lesson::UPLOAD_PATH_LESSON_SCORM ."/". $this->getScormFile());
            }
            $this->deleteDir(Lesson::UPLOAD_PATH_LESSON_SCORM ."/". str_replace('.zip', '', $this->getScormFile()));
        }
    }

    /**
     * Manages the copying of the file to the relevant place on the server
     */
    public function uploadFile()
    {
        // Upload Cover
        $this->uploadCover();

        // Upload Scorm
        $this->uploadScorm();
    }

    public function uploadCover()
    {
        //Upload de cover
        if ($this->getCoverTemp()!=null) {
            //Se o diretorio não existir, cria
            if (!file_exists(Lesson::UPLOAD_PATH_LESSON_COVER)) {
                mkdir(Lesson::UPLOAD_PATH_LESSON_COVER, 0755, true);
            }
            if (($this->getCoverTemp() != $this->getCover())
              && (null !== $this->getCover())
            ) {
                unlink(Lesson::UPLOAD_PATH_LESSON_COVER ."/". $this->getCover());
            }

            // Generate a unique name for the file before saving it
            $fileName = md5(uniqid()).'.'.$this->getCoverTemp()->guessExtension();

            UploadService::compress($this->getCoverTemp(), Lesson::UPLOAD_PATH_LESSON_COVER."/".$fileName, 100);

            // set the path property to the filename where you've saved the file
            $this->cover = $fileName;

            // clean up the file property as you won't need it anymore
            $this->setCoverTemp(null);
        }
    }

    public function uploadScorm()
    {
        //Upload de scorm
        if ($this->getScormFileTemp()!=null) {
            //Se o diretorio não existir, cria
            if (!file_exists(Lesson::UPLOAD_PATH_LESSON_SCORM)) {
                mkdir(Lesson::UPLOAD_PATH_LESSON_SCORM, 0755, true);
            }
            if (($this->getScormFileTemp() != $this->getScormFile())
              && (null !== $this->getScormFile())
            ) {
                // Verificar se existe arquivo para apagar
                unlink(Lesson::UPLOAD_PATH_LESSON_SCORM ."/". $this->getScormFile());
                $this->deleteDir(Lesson::UPLOAD_PATH_LESSON_SCORM ."/". str_replace('.zip', '', $this->getScormFile()));
            }

            //Generate a unique name for the file before saving it
            $fileName = md5(uniqid());
            $fullFileName = $fileName.'.'.$this->getScormFileTemp()->guessExtension();

            UploadService::upload($this->getScormFileTemp(), Lesson::UPLOAD_PATH_LESSON_SCORM."/".$fullFileName);

            // set the path property to the filename where you've saved the file
            $this->scormFile = $fullFileName;

            // clean up the file property as you won't need it anymore
            $this->setScormFileTemp(null);

            //Extrair o arquivo no diretório
            $zip = new \ZipArchive;
            $res = $zip->open(Lesson::UPLOAD_PATH_LESSON_SCORM."/".$fullFileName);
            if ($res === true) {
                $zip->extractTo(Lesson::UPLOAD_PATH_LESSON_SCORM."/".$fileName);
                $zip->close();
            }
        }
    }

    public function deleteDir($dirPath)
    {
        if (! is_dir($dirPath)) {
            // throw new InvalidArgumentException('$dirPath must be a directory');
            return false;
        }
        if (substr($dirPath, strlen($dirPath) - 1, 1) != '/') {
            $dirPath .= '/';
        }
        $files = glob($dirPath . '*', GLOB_MARK);
        foreach ($files as $file) {
            if (is_dir($file)) {
                self::deleteDir($file);
            } else {
                unlink($file);
            }
        }
        rmdir($dirPath);
    }
}

/* Usage
 Grab some XML data, either from a file, URL, etc. however you want. Assume storage in $strYourXML;

 $objXML = new xml2Array();
 $arroutput = $objXML->parse($strYourXML);
 print_r($arroutput); //print it out, or do whatever!

*/
class xml2Array
{
    public $arroutput = array();
    public $resparser;
    public $strxmldata;

    /**
     * Convert a utf-8 string to html entities
     *
     * @param string $str The UTF-8 string
     * @return string
     */
    public function utf8_to_entities($str)
    {
        global $CFG;

        $entities = '';
        $values = array();
        $lookingfor = 1;

        return $str;
    }

    /**
     * Parse an XML text string and create an array tree that rapresent the XML structure
     *
     * @param string $strinputxml The XML string
     * @return array
     */
    public function parse($strinputxml)
    {
        $this->resparser = xml_parser_create('UTF-8');
        xml_set_object($this->resparser, $this);
        xml_set_element_handler($this->resparser, "tagopen", "tagclosed");

        xml_set_character_data_handler($this->resparser, "tagdata");

        $this->strxmldata = xml_parse($this->resparser, $strinputxml);
        if (!$this->strxmldata) {
            die(sprintf(
                "XML error: %s at line %d",
            xml_error_string(xml_get_error_code($this->resparser)),
            xml_get_current_line_number($this->resparser)
            ));
        }

        xml_parser_free($this->resparser);

        return $this->arroutput;
    }

    public function tagopen($parser, $name, $attrs)
    {
        $tag = array("name" => $name, "attrs" => $attrs);
        array_push($this->arroutput, $tag);
    }

    public function tagdata($parser, $tagdata)
    {
        if (trim($tagdata)) {
            if (isset($this->arroutput[count($this->arroutput) - 1]['tagData'])) {
                $this->arroutput[count($this->arroutput) - 1]['tagData'] .= $this->utf8_to_entities($tagdata);
            } else {
                $this->arroutput[count($this->arroutput) - 1]['tagData'] = $this->utf8_to_entities($tagdata);
            }
        }
    }

    public function tagclosed($parser, $name)
    {
        $this->arroutput[count($this->arroutput) - 2]['children'][] = $this->arroutput[count($this->arroutput) - 1];
        array_pop($this->arroutput);
    }
}
