<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * LessonFiles
 *
 * @ORM\Table(name="lesson_files")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\LessonFilesRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class LessonFiles
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="file", type="string", length=255, nullable=true)
     */
    private $file;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_create", type="datetime")
     * @Gedmo\Timestampable(on="create")
     */
    private $dtCreate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_update", type="datetime")
     * @Gedmo\Timestampable(on="update")
     */
    private $dtUpdate;

    /**
     * @var Lesson
     *
     * @ORM\ManyToOne(targetEntity="Lesson", inversedBy="lessonFiles")
     * @ORM\JoinColumn(name="lesson_id", referencedColumnName="id", nullable=true)
     */
    private $lesson;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return LessonFiles
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set file
     *
     * @param string $file
     *
     * @return LessonFiles
     */
    public function setFile($file)
    {
        $this->file = $file;

        return $this;
    }

    /**
     * Get file
     *
     * @return string
     */
    public function getFile()
    {
        return $this->file;
    }

    /**
     * Set dtCreate
     *
     * @param \DateTime $dtCreate
     *
     * @return LessonFiles
     */
    public function setDtCreate($dtCreate)
    {
        $this->dtCreate = $dtCreate;

        return $this;
    }

    /**
     * Get dtCreate
     *
     * @return \DateTime
     */
    public function getDtCreate()
    {
        return $this->dtCreate;
    }

    /**
     * Set dtUpdate
     *
     * @param \DateTime $dtUpdate
     *
     * @return Payment
     */
    public function setDtUpdate($dtUpdate)
    {
        $this->dtUpdate = $dtUpdate;

        return $this;
    }

    /**
     * Get dtUpdate
     *
     * @return \DateTime
     */
    public function getDtUpdate()
    {
        return $this->dtUpdate;
    }

    /**
     * Set lesson
     *
     * @param integer $lesson
     *
     * @return LessonFiles
     */
    public function setLesson($lesson)
    {
        $this->lesson = $lesson;

        return $this;
    }

    /**
     * Get lesson
     *
     * @return int
     */
    public function getLesson()
    {
        return $this->lesson;
    }

    // Constante com o caminho para salvar a imagem screenshot
    const UPLOAD_PATH_LESSON_FILE = 'uploads/lesson/file';

    /**
     * @Assert\File(
     *     maxSize = "100000k",
     *     maxSizeMessage = "O tamanho da imagem é muito grande ({{ size }} {{ suffix }}), escolha um arquivo de até {{ limit }} {{ suffix }}",
     *     mimeTypesMessage = "Formato de arquivo inválido."
     * )
     */
    private $fileTemp;

   /**
     * Sets fileTemp
     *
     * @param UploadedFile $fileTemp
     */
    public function setFileTemp(UploadedFile $fileTemp = null)
    {
        $this->fileTemp = $fileTemp;
    }

    /**
     * Get fileTemp
     *
     * @return UploadedFile
     */
    public function getFileTemp()
    {
        return $this->fileTemp;
    }

  /**
     * Unlink Photo (Apagar foto quando excluir objeto)
     */
    public function unlinkImages()
    {
        if ($this->getFile() != null) {
            unlink(LessonFiles::UPLOAD_PATH_LESSON_FILE ."/". $this->getFile());
        }
  }

    /**
     * Manages the copying of the file to the relevant place on the server
     */
    public function uploadImage()
    {

        if($this->getFileTemp()!=null){
          //Se o diretorio não existir, cria
          if (!file_exists(LessonFiles::UPLOAD_PATH_LESSON_FILE)) {
              mkdir(LessonFiles::UPLOAD_PATH_LESSON_FILE, 0755, true);
          }
          if(
              ($this->getFileTemp() != $this->getFile())
              && (null !== $this->getFile())
          ){
              unlink(LessonFiles::UPLOAD_PATH_LESSON_FILE ."/". $this->getFile());
          }

          $fileName = md5(uniqid()).'.'.$this->getFileTemp()->guessExtension();

          UploadService::upload($this->getFileTemp(), LessonFiles::UPLOAD_PATH_LESSON_FILE."/".$fileName);

          $this->file = $fileName;

          $this->setFileTemp(null);
        }

    }

    /**
     * @ORM\PostLoad()
     */
    public function postLoad()
    {
        $this->dtUpdate = new \DateTime();
    }

    /**
     * Lifecycle callback to upload the file to the server
     * @ORM\PrePersist
     * @ORM\PreUpdate
     */
    public function lifecycleFileUpload() {
        $this->uploadImage();
    }
}
