<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Type;

/**
* LikePost
*
* @ORM\Table(name="like_post")
* @ORM\Entity(repositoryClass="AppBundle\Repository\LikePostRepository")
*/
class LikePost
{
/**
* @var int
*
* @ORM\Column(name="id", type="integer")
* @ORM\Id
* @ORM\GeneratedValue(strategy="AUTO")
*/
private $id;

/**
* @var User
*
* @ORM\ManyToOne(targetEntity="UserBundle\Entity\User")
* @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=true)
*/
private $user;

/**
* @var Post
*
* @ORM\ManyToOne(targetEntity="Post")
* @ORM\JoinColumn(name="post_id", referencedColumnName="id", onDelete="CASCADE", nullable=true)
*/
private $post;

/**
* @var \DateTime
*
* @ORM\Column(name="dt_creation", type="datetime")
* @Gedmo\Timestampable(on="create")
* @Expose
*/
private $dtCreation;

/**
* @var \DateTime
*
* @ORM\Column(name="dt_update", type="datetime")
* @Gedmo\Timestampable(on="update")
* @Expose
*/
private $dtUpdate;

/**
* Get id
*
* @return integer
*/
public function getId()
{
    return $this->id;
}

/**
* Set dtCreation
*
* @param \DateTime $dtCreation
*
* @return LikePost
*/
public function setDtCreation($dtCreation)
{
    $this->dtCreation = $dtCreation;

    return $this;
}

/**
* Get dtCreation
*
* @return \DateTime
*/
public function getDtCreation()
{
    return $this->dtCreation;
}

/**
* Set dtUpdate
*
* @param \DateTime $dtUpdate
*
* @return LikePost
*/
public function setDtUpdate($dtUpdate)
{
    $this->dtUpdate = $dtUpdate;

    return $this;
}

/**
* Get dtUpdate
*
* @return \DateTime
*/
public function getDtUpdate()
{
    return $this->dtUpdate;
}

/**
* Set user
*
* @param \UserBundle\Entity\User $user
*
* @return LikePost
*/
public function setUser(\UserBundle\Entity\User $user = null)
{
    $this->user = $user;

    return $this;
}

/**
* Get user
*
* @return \UserBundle\Entity\User
*/
public function getUser()
{
    return $this->user;
}

/**
* Set post
*
* @param \AppBundle\Entity\Post $post
*
* @return LikePost
*/
public function setPost(\AppBundle\Entity\Post $post = null)
{
    $this->post = $post;

    return $this;
}

/**
* Get post
*
* @return \AppBundle\Entity\Post
*/
public function getPost()
{
    return $this->post;
}
}
