<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * ManagementLearningTrail
 *
 * @ORM\Table(name="management_learningtrail")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\ManagementLearningTrailRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class ManagementLearningTrail
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var LearningTrail
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\LearningTrail")
     * @ORM\JoinColumn(name="learningtrail_id", referencedColumnName="id")
     */
    private $learningTrail;

    /**
     * @var Management
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Management")
     * @ORM\JoinColumn(name="management_id", referencedColumnName="id", nullable=true)
     */
    private $management;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set learningTrail
     *
     * @param \AppBundle\Entity\ManagementLearningTrail $learningTrail
     *
     * @return ManagementLearningTrail
     */
    public function setLearningTrail(\AppBundle\Entity\LearningTrail $learningTrail = null)
    {
        $this->learningTrail = $learningTrail;

        return $this;
    }

    /**
     * Get learningTrail
     *
     * @return \AppBundle\Entity\Category
     */
    public function getLearningTrail()
    {
        return $this->learningTrail;
    }

    /**
     * Set management
     *
     * @param \AppBundle\Entity\Management $management
     *
     * @return ManagementLearningTrail
     */
    public function setManagement(\AppBundle\Entity\Management $management = null)
    {
        $this->management = $management;

        return $this;
    }

    /**
     * Get management
     *
     * @return \AppBundle\Entity\Client
     */
    public function getManagement()
    {
        return $this->management;
    }
}
