<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use AppBundle\Service\UploadService;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Type;

/**
 * Class
 *
 * @ORM\Table(name="question")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\QuestionRepository")
 * @ExclusionPolicy("all")
 */
class Question
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Expose
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="text", nullable=true)
     * @Expose
     */
    private $name;

    /**
     * @var Evaluation
     *
     * @ORM\ManyToOne(targetEntity="Evaluation", inversedBy="questions")
     * @ORM\JoinColumn(name="evaluation_id", referencedColumnName="id", nullable=true)
     * @Expose
     */
    private $evaluation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_creation", type="datetime")
     * @Gedmo\Timestampable(on="create")
     * @Expose
     */
    private $dtCreation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dt_update", type="datetime")
     * @Gedmo\Timestampable(on="update")
     * @Expose
     */
    private $dtUpdate;

    /**
     * @ORM\OneToMany(targetEntity="QuestionItem", mappedBy="question", cascade={"all"}, orphanRemoval=true)
     */
    private $questionitems;

    /**
     * @ORM\OneToMany(targetEntity="Answer", mappedBy="question", cascade={"all"})
     */
    protected $answers;


    public function __construct()
    {
        $this->questionitems = new ArrayCollection();
        $this->answers = new ArrayCollection();
    }

    /**
     * Set id
     *
     * @param integer $id;
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Question
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set evaluation
     *
     * @param Evaluation $evaluation
     * @return Question
     */
    public function setEvaluation($evaluation = null)
    {
        $this->evaluation = $evaluation;

        return $this;
    }

    /**
     * Get evaluation
     *
     * @return Question
     */
    public function getEvaluation()
    {
        return $this->evaluation;
    }

    public function addQuestionItem(QuestionItem $questionItem)
    {
        $questionItem->setQuestion($this);

        $this->questionitems->add($questionItem);
    }

    public function removeQuestionItem(QuestionItem $questionItem)
    {
        $this->questionitems->removeElement($questionItem);
    }

    /**
     * Set questionitems
     *
     * @param string $questionitems
     * @return Question
     */
    public function setQuestionitems($questionitems)
    {
        $this->questionitems = $questionitems;

        return $this;
    }

    /**
     * Get questionitems
     *
     * @return string
     */
    public function getQuestionitems()
    {
        return $this->questionitems;
    }

    /**
     * Set dtCreation
     *
     * @param \DateTime $dtCreation
     *
     * @return Payment
     */
    public function setDtCreation($dtCreation)
    {
        $this->dtCreation = $dtCreation;

        return $this;
    }

    /**
     * Get dtCreation
     *
     * @return \DateTime
     */
    public function getDtCreation()
    {
        return $this->dtCreation;
    }

    /**
     * Set dtUpdate
     *
     * @param \DateTime $dtUpdate
     *
     * @return Payment
     */
    public function setDtUpdate($dtUpdate)
    {
        $this->dtUpdate = $dtUpdate;

        return $this;
    }

    /**
     * Get dtUpdate
     *
     * @return \DateTime
     */
    public function getDtUpdate()
    {
        return $this->dtUpdate;
    }

    public function setAnswers($answers)
    {
        $this->answers = $answers;

        return $this;
    }

    /**
     * Get answers
     *
     * @return string
     */
    public function getAnswers()
    {
        return $this->answers;
    }


    /*
    * Transient field
    */
    private $questionItem;

    /**
     * Questão selecionada
     */
    public function setQuestionItem($questionItem)
    {
        $this->questionItem = $questionItem;

        return $this;
    }
    /**
     * Obtem a questao selecionada\
     *
     * @return string
     */
    public function getQuestionItem()
    {
        return $this->questionItem;
    }
}
