<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use IdeasBucket\QueueBundle\Entity\DatabaseQueueEntityInterface as EntityInterface;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Class QueueJobMail
 *
 * @package AppBundle\Entity
 *
 * @ORM\Table(name="queue_job_mail")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\QueueJobMailRepository")
 */
class QueueJobMail
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", options={"unsigned":true})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="report", type="string", nullable=false)
     */
    private $report;

    /**
     * @var string
     *
     * @ORM\Column(name="email", type="string", length=500, nullable=false)
     */
    private $email;

    /**
     * @var string
     *
     * @ORM\Column(name="path_file", type="string", nullable=true, length=500)
     */
    private $pathFile;

    /**
     * @var boolean
     *
     * @ORM\Column(name="sended", type="boolean", nullable=false)
     */
    private $sended;

    /**
     * @var boolean
     *
     * @ORM\Column(name="error_execution", type="boolean", nullable=false)
     */
    private $errorExecution;

    /**
     * @var text
     *
     * @ORM\Column(name="observation", type="text", nullable=true)
     */
    private $observation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created_at", type="datetime")
     * @Gedmo\Timestampable(on="update")
     */
    private $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updated_at", type="datetime")
     * @Gedmo\Timestampable(on="update")
     */
    private $updatedAt;

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get report
     *
     * @return string
     */
    public function getReport()
    {
        return $this->report;
    }

    /**
     * Set report
     *
     * @param string $report;
     */
    public function setReport($report)
    {
        $this->report = $report;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set email
     *
     * @param string $email;
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }
    
    /**
     * Get pathFile
     *
     * @return string
     */
    public function getPathFile()
    {
        return $this->pathFile;
    }

    /**
     * Set pathFile
     *
     * @param string $pathFile;
     */
    public function setPathFile($pathFile)
    {
        $this->pathFile = $pathFile;
    }

    /**
     * Get sended
     *
     * @return string
     */
    public function getSended()
    {
        return $this->sended;
    }

    /**
     * Set sended
     *
     * @param string $sended;
     */
    public function setSended($sended)
    {
        $this->sended = $sended;
    }

    /**
     * Get errorExecution
     *
     * @return string
     */
    public function getErrorExecution()
    {
        return $this->errorExecution;
    }

    /**
     * Set errorExecution
     *
     * @param string $errorExecution;
     */
    public function setErrorExecution($errorExecution)
    {
        $this->errorExecution = $errorExecution;
    }

    /**
     * Get observation
     *
     * @return string
     */
    public function getObservation()
    {
        return $this->observation;
    }

    /**
     * Set observation
     *
     * @param string $observation;
     */
    public function setObservation($observation)
    {
        $this->observation = $observation;
    }

    /**
     * Set createdAt
     *
     * @param \DateTime $createdAt
     *
     * @return Payment
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Set updatedAt
     *
     * @param \DateTime $updatedAt
     *
     * @return Payment
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    
}
