<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * SimplesamlDictionary
 *
 * @ORM\Table(name="simplesaml_dictionary")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\SimplesamlDictionaryRepository")
 */
class SimplesamlDictionary
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="chave", type="string", length=255)
     */
    private $chave;

    /**
     * @var string
     *
     * @ORM\Column(name="chave_simplesaml", type="string", length=255)
     */
    private $chaveSimplesaml;

    /**
     * @var string
     *
     * @ORM\Column(name="chave_lms", type="string", length=255)
     */
    private $chaveLms;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set chave
     *
     * @param string $chave
     *
     * @return SimplesamlDictionary
     */
    public function setChave($chave)
    {
        $this->chave = $chave;

        return $this;
    }

    /**
     * Get chave
     *
     * @return string
     */
    public function getChave()
    {
        return $this->chave;
    }

    /**
     * Set chaveSimplesaml
     *
     * @param string $chaveSimplesaml
     *
     * @return SimplesamlDictionary
     */
    public function setChaveSimplesaml($chaveSimplesaml)
    {
        $this->chaveSimplesaml = $chaveSimplesaml;

        return $this;
    }

    /**
     * Get chaveSimplesaml
     *
     * @return string
     */
    public function getChaveSimplesaml()
    {
        return $this->chaveSimplesaml;
    }

    /**
     * Set chaveLms
     *
     * @param string $chaveLms
     *
     * @return SimplesamlDictionary
     */
    public function setChaveLms($chaveLms)
    {
        $this->chaveLms = $chaveLms;

        return $this;
    }

    /**
     * Get chaveLms
     *
     * @return string
     */
    public function getChaveLms()
    {
        return $this->chaveLms;
    }
}

