<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * UserAccessControl
 *
 * @ORM\Table(name="user_access_control")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\UserAccessControlRepository")
 */
class UserAccessControl
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var AccessControl
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\AccessControl")
     * @ORM\JoinColumn(name="access_control_id", referencedColumnName="id", nullable=true, onDelete="SET NULL")
     */
    private $accessControl;

    /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="UserBundle\Entity\User")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=true, onDelete="SET NULL")
     */
    private $user;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set accessControl
     *
     * @param \AppBundle\Entity\AccessControl $accessControl
     *
     * @return UserAccessControl
     */
    public function setAccessControl(\AppBundle\Entity\AccessControl $accessControl = null)
    {
        $this->accessControl = $accessControl;

        return $this;
    }

    /**
     * Get accessControl
     *
     * @return \AppBundle\Entity\AccessControl
     */
    public function getAccessControl()
    {
        return $this->accessControl;
    }

    /**
     * Set user
     *
     * @param \UserBundle\Entity\User $user
     *
     * @return UserAccessControl
     */
    public function setUser(\UserBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \UserBundle\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }
}
