<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * UserGroup
 *
 * @ORM\Table(name="user_group")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\UserGroupRepository")
 */
class UserGroup
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="item_group", type="text")
     */
    private $itemGroup;

    /**
     * @var string
     *
     * @ORM\Column(name="item_keys", type="text")
     */
    private $itemKeys;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="string", length=255)
     */
    private $description;

    /**
     * @var string
     *
     * @ORM\Column(name="cooperated", type="boolean", nullable=true)
     */
    private $cooperated;

    /**
     * @var string
     *
     * @ORM\Column(name="active", type="boolean", nullable=true)
     */
    private $active;

    /**
     * __toString method
     */
    public function __toString() {
        return $this->getDescription();
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set itemGroup
     *
     * @param string $itemGroup
     *
     * @return UserGroup
     */
    public function setItemGroup($itemGroup)
    {
        $this->itemGroup = $itemGroup;

        return $this;
    }

    /**
     * Get itemGroup
     *
     * @return string
     */
    public function getItemGroup()
    {
        return $this->itemGroup;
    }

    /**
     * Set itemKeys
     *
     * @param string $itemKeys
     *
     * @return UserGroup
     */
    public function setItemKeys($itemKeys)
    {
        $this->itemKeys = $itemKeys;

        return $this;
    }

    /**
     * Get itemKeys
     *
     * @return string
     */
    public function getItemKeys()
    {
        return $this->itemKeys;
    }

    /**
     * Set description
     *
     * @param string $description
     *
     * @return UserGroup
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set cooperated
     *
     * @param string $cooperated
     *
     * @return UserGroup
     */
    public function setCooperated($cooperated)
    {
        $this->cooperated = $cooperated;

        return $this;
    }

    /**
     * Get cooperated
     *
     * @return string
     */
    public function getCooperated()
    {
        return $this->cooperated;
    }

    /**
     * Set active
     *
     * @param string $active
     *
     * @return UserGroup
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * Get active
     *
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }
}

