<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;

class AccessControlType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('description', TextType::class, array(
                'label' => 'Descrição',
                'required' => true
            ))
            // ->add('permission', ChoiceType::class, array(
            //     // 'label' => 'Aparecer para',
            //     'empty_data' => 'Selecione a permissão',
            //     'choices' => array(
            //         'show' => 'Consulta',
            //         'edit' => 'Edição',
            //     )
            // ))
            ->add('accessPermissions', CollectionType::class, array(
                'entry_type' => AccessPermissionControlType::class,
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
            ))
            ->add('enterprises', CollectionType::class, array(
                'entry_type' => EnterpriseAccessControlType::class,
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
            ))
        ;
    }/**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\AccessControl'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'accessControl';
    }
}
