<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
// use Symfony\Component\Form\Extension\Core\Type\EntityType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;

class BannerType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, array(
                'label' => 'Nome',
                'required' => true
            ))
            ->add('title', TextType::class, array(
                'label' => 'Título',
                'required' => false
            ))
            ->add('description', TextType::class, array(
                'label' => 'Descrição',
                'required' => false
            ))
            ->add('url', TextType::class, array(
                'label' => 'URL',
                'required' => false
            ))
            ->add('displayFor', ChoiceType::class, array(
                'label' => 'Aparecer para',
                'choices'  => array(
                    'all' => 'Todos',
                    'cooperative' => 'Cooperados',
                    'contributors' => 'Colaboradores',
                )
            ))
            ->add('active')
            ->add('image', 'hidden', array())
            ->add('imageTemp', 'file', array(
                'label' => 'Banner - Escolha uma imagem de pelo menos 1280x480px e tamanho máximo do arquivo: 1.5MB',
                'required' => false
            ))
            ->add('bannerFilter', EntityType::class, array(
                'class' => 'AppBundle:BannerFilter',
                'choice_label' => 'id',
            ))
            ->add('numEmp', TextType::class, array(
                'required' => false,
                'label' => 'Empresa',
            ))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\Banner'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'banner';
    }
}
