<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Form\Extension\Core\Type\FileType;

class ClientBackendType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('first_name')
            ->add('last_name')
            ->add('login')
            ->add('usergroup', 'entity', array(
                'required' => true,
                'empty_value' => '',
                'class' => 'AppBundle:UserGroup',
            ))
            ->add('email')
            ->add('cpf')
            ->add('celphone')
            ->add('phone')
            ->add('photo', 'hidden', array())
            ->add('sector', 'entity', array(
                'required' => true,
                'class' => 'AppBundle:Sector',
            ))
            ->add('jobRole', 'entity', array(
                'required' => true,
                'class' => 'AppBundle:JobRole',
            ))
            // ->add('sector')
            // ->add('jobRole')
            ->add('management')
            ->add('accessGranted')
            ->add('mat_colaborador')
            // ->add('userStatus')
            ->add('userStatus', 'entity', array(
                'required' => true,
                'class' => 'AppBundle:UserStatus',
            ))
            ->add('num_enterprise')
            ->add('tip_colaborador')
            ->add('photoTemp', FileType::class, array(
                'label' => 'Imagem de perfil',
                'required' => false
            ))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\Client'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'userbundle_user';
    }
}
