<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
// use Symfony\Component\Form\Extension\Core\Type\EntityType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;

class ConfigurationType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('certificateFront', 'hidden', array())
            ->add('certificateFrontTemp', 'file', array(
                'label' => 'Certificado - Tamanho máximo do arquivo: 1.5MB',
                'required' => false
            ))
            ->add('certificateBack', 'hidden', array())
            ->add('certificateBackTemp', 'file', array(
                'label' => 'Certificado - Verso - Tamanho máximo do arquivo: 1.5MB',
                'required' => false
            ))
            ->add('signature', 'hidden', array())
            ->add('signatureTemp', 'file', array(
                'label' => 'Assinatura - Tamanho máximo do arquivo: 1.5MB',
                'required' => false
            ))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\Configuration'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'configuration';
    }
}
