<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;

class ContactType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name')
            ->add('email', 'email')
            ->add('phone')
            ->add('subject')
            ->add('type', 'choice', array(
                'choices'  => array(
                    '' => 'Selecione',
                    'Cooperado' => 'Cooperado',
                    'Colaborador' => 'Colaborador',
                ),
                'required' => true,
            ))
            ->add('topic', 'choice', array(
                'choices'  => array(
                    '' => 'Selecione',
                    'Sugestao' => 'Sugestão',
                    'Reclamacao' => 'Reclamação',
                    'Duvida' => 'Dúvida',
                    'Elogio' => 'Elogio',
                    'Outros' => 'Outros',
                ),
                'required' => true,
            ))
            ->add('message', 'textarea');
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\Contact'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'contact';
    }
}
