<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Doctrine\ORM\EntityRepository;

class CourseClassType extends AbstractType
{


    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $builder
            ->add('description')
            ->add('course', 'entity', array(
                'required' => true,
                'empty_value' => '',
                'class' => 'AppBundle:Course',
                'query_builder' => function(EntityRepository $er) {
                    return $er->createQueryBuilder('c')
                            ->where("c.modality = 'Presencial' and c.active = 1")
                            ->orderBy('c.title', 'ASC')
                    ;
                },
            ))
            // ->add('dtBegin', 'date', array(
            //     'empty_value' => '',
            //     'widget' => 'single_text',
            //     'format' => 'dd/MM/yyyy H:i',
            //     'attr' => array('class'=>'form-control date-time-picker course-class-begin', "autocomplete" => "off"),
            //     'required' => true,
            // ))
            // ->add('dtEnd', 'date', array(
            //     'empty_value' => '',
            //     'widget' => 'single_text',
            //     'format' => 'dd/MM/yyyy H:i',
            //     'attr' => array('class'=>'form-control date-time-picker course-class-end', "autocomplete" => "off"),
            //     'required' => true,
            // ))
            ->add('eventClass', CollectionType::class, array(
                'entry_type' => EventClassType::class,
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
            ))
            ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\CourseClass'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'courseclass';
    }
}
