<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Doctrine\ORM\EntityRepository;
use Ivory\CKEditorBundle\Form\Type\CKEditorType;

class CourseType extends AbstractType
{
    protected $company;

    public function __construct($company = null)
    {
        $this->company = $company;
    }

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $company = $this->company;
        $builder
            ->add('name')
            ->add('title')
            ->add('active')
            ->add('autoInscription')
            ->add('linkTrailExternal', TextType::class, array(
                'label' => 'Link curso externo',
                'required' => false
            ))
            ->add('conclusionLink', TextType::class, array(
                'label' => 'Após a certificação, o aluno será redirecionado para:',
                'required' => false
            ))
            ->add('description', CKEditorType::class, array(
                'config' => array(
                    'allowedContent' => true,
                    'filebrowser_image_browse_url' => array(
                        'route'            => 'elfinder',
                        'route_parameters' => array('instance' => 'ckeditor'),
                    )
                ),
            ))
            ->add('shortDescription', CKEditorType::class, array(
                'config' => array(
                    'allowedContent' => true,
                    'filebrowser_image_browse_url' => array(
                        'route' => 'elfinder',
                        'route_parameters' => array('instance' => 'ckeditor'),
                    )
                ),
            ))
            ->add('cover', 'hidden', array())
            ->add('coverTemp', 'file', array(
                'label' => 'Thumbnail - Tamanho ideal 300x200px',
                'required' => false
            ))
            ->add('scormFile', 'hidden', array())
            ->add('scormFileTemp', 'file', array(
                'label' => 'Scorm',
                'required' => false
            ))
            ->add('certificate', 'hidden', array())
            ->add('certificateTemp', 'file', array(
                'label' => 'Certificado',
                'required' => false
            ))
            ->add('certificateBack', 'hidden', array())
            ->add('certificateBackTemp', 'file', array(
                'label' => 'Certificado - Verso',
                'required' => false
            ))
            ->add('idMediaDegustacao', 'hidden', array())
            ->add('autor', TextType::class, array(
                    'label' => 'Autor',
                    'required' => false
            ))
            ->add('duracaoCurso', TextType::class, array(
                    'label' => 'Duração do curso (horas)',
                    'required' => false
            ))
            ->add('notaMedia', TextType::class, array(
                    'label' => 'Nota média',
                    'required' => true
            ))
            ->add('category')
            ->add('survey')
            ->add('salutarisId')
            ->add('disponibleDays', IntegerType::class, array('required' => false))
            ->add('pontuation', IntegerType::class, array('required' => false))
            ->add('moduleDependency')
            ->add('modality', ChoiceType::class, array(
                'label' => 'Modalidade de Curso',
                'empty_value' => 'Selecione um item',
                'choices'  => array(
                    // '' => 'Selecione uma modalidade',
                    'Presencial' => 'Presencial',
                    'EAD' => 'EAD',
                )
            ))
            ->add('dtInitial', 'date', array(
                'empty_value' => '',
                'widget' => 'single_text',
                'format' => 'dd/MM/yyyy',
                'attr' => array('class'=>'form-control date-picker'),
                'required' => false
            ))
            ->add('dtEnd', 'date', array(
                'empty_value' => '',
                'widget' => 'single_text',
                'format' => 'dd/MM/yyyy',
                'attr' => array('class'=>'form-control date-picker'),
                'required' => false
            ))
            ->add('dtInscriptionBegin', 'date', array(
                'empty_value' => '',
                'widget' => 'single_text',
                'format' => 'dd/MM/yyyy',
                'attr' => array('class'=>'form-control date-picker'),
                'required' => false
            ))
            ->add('dtInscriptionEnd', 'date', array(
                'empty_value' => '',
                'widget' => 'single_text',
                'format' => 'dd/MM/yyyy',
                'attr' => array('class'=>'form-control date-picker'),
                'required' => false
            ))
            ->add('quantvagas')
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\Course'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'course';
    }
}
