<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Ivory\CKEditorBundle\Form\Type\CKEditorType;

class EventClassType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('description')
            ->add('dtBegin', 'date', array(
                'empty_value' => '',
                'widget' => 'single_text',
                'format' => 'dd/MM/yyyy',
                'attr' => array('class'=>'form-control date-picker event-class-begin', "autocomplete" => "off"),
                'required' => true,
            ))
            ->add('dtEnd', 'date', array(
                'empty_value' => '',
                'widget' => 'single_text',
                'format' => 'dd/MM/yyyy',
                'attr' => array('class'=>'form-control date-picker event-class-end', "autocomplete" => "off"),
                'required' => true,
            ))
            ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\EventClass'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'eventclass_item';
    }
}
