<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;

class IqaCicleType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('description')
        ->add('beginDate', 'date', array(
            'empty_value' => '',
            'widget' => 'single_text',
            'format' => 'dd/MM/yyyy',
            'attr' => array('class'=>'form-control date-picker', "autocomplete" => "off"),
            'required' => false
        ))
        ->add('endDate', 'date', array(
            'empty_value' => '',
            'widget' => 'single_text',
            'format' => 'dd/MM/yyyy',
            'attr' => array('class'=>'form-control date-picker', "autocomplete" => "off"),
            'required' => false
        ))
        ->add('iqamidias', CollectionType::class, array(
            'entry_type' => IqaMidiaType::class,
            'allow_add' => true,
            'allow_delete' => true,
            'by_reference' => false,
        ));
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\IqaCicle'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'iqa_cicle';
    }
}
