<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;

class IqaMidiaType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('id', 'hidden', array())
            ->add('midiaIdTemp')
            ->add('midiaTypeTemp')
            ->add('mediaName')
            ->add('percentage', IntegerType::class, array('required' => false, 'attr' => array('class'=>'form-control', 'min'=>'0', 'max'=>'100', 'placeholder'=>"Percentual"),))
            ->add('mandatory', CheckboxType::class, array(
            'required' => false,
            ))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\IqaMidia'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'iqa_midia';
    }
}
