<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class LearningTrailType extends AbstractType
{


    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $builder
            ->add('name')
            ->add('courses', HiddenType::class)
            ->add('cover', 'hidden', array())
            ->add('coverTemp', 'file' , array(
                'label' => 'Thumbnail',
                'required' => false
            ))
            ->add('dependency')
            ->add('public')
            ->add('description')
            ->add('managementLearningTrail', CollectionType::class, array(
                'entry_type' => ManagementLearningTrailType::class,
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
                'required' => true,
            ))
            ->add('numEmp', TextType::class, array(
                'required' => false,
                'label' => 'Empresa',
            ));
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\LearningTrail'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'learningtrail';
    }
}
