<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Ivory\CKEditorBundle\Form\Type\CKEditorType;

class PostType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('title',
            TextType::class,
            array(
                'label' => 'Título',
                'max_length' => 255,
                'required' => false
            )
        )
        ->add('short_content',
            TextType::class,
            array(
                'label' => 'Título',
                'required' => false
            )
        )
        ->add('content', CKEditorType::class, array(
            'config' => array(
                'allowedContent' => true,
                'filebrowser_image_browse_url' => array(
                    'route'            => 'elfinder',
                    'route_parameters' => array('instance' => 'ckeditor'),
                )
            ),
        ))
        ->add('active')
        ->add('file', 'hidden', array())
        ->add('fileTemp',
                    'file' ,
                    array(
                        'label' => 'Cover - Tamanho e Dimensões recomendados: 2MB e 510 x 340',
                        'required' => false
                    )
            );
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\Post'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'post';
    }
}
