<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;

class ReportScriptLabelType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('variable', TextType::class, [
                'label' => "Variável",
                'attr' => [
                    'placeholder' => 'Variável',
                    'class' => 'form-control',
                ],
                'required' => true,
            ])
            ->add('name', TextType::class, [
                'label' => "Nome",
                'attr' => [
                    'placeholder' => 'Nome',
                    'class' => 'form-control',
                ],
                'required' => true,
            ])
            ->add('delete', ButtonType::class, array(
                'label' => 'Excluir',
                'attr' => array('class' => 'btn btn-danger remove-label-button'),
            ));
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\ReportScriptLabel',
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'report_script_label';
    }
}
