<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class SearchReportType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('beginDate', 'date', array(
                'empty_value' => '',
                'widget' => 'single_text',
                'format' => 'dd/MM/yyyy',
                'attr' => array('class'=>'form-control date-picker'),
                'required' => false
            ))
            ->add('endDate', 'date', array(
                'empty_value' => '',
                'widget' => 'single_text',
                'format' => 'dd/MM/yyyy',
                'attr' => array('class'=>'form-control date-picker'),
                'required' => false
            ))
            ->add('course', 'entity', array(
                'empty_value' => "",
                'required' => false,
                'class' => 'AppBundle:Course',
            ))
            ->add('inscriptionStatus', 'entity', array(
                'empty_value' => "",
                'required' => false,
                'class' => 'AppBundle:InscriptionStatus',
            ))
            ->add('paymentStatus', 'entity', array(
                'empty_value' => "",
                'required' => false,
                'class' => 'AppBundle:PaymentStatus',
            ));
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\SearchReport',
            'csrf_protection' => false,
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'search_report';
    }
}
