<?php

namespace AppBundle\Job;

use Doctrine\ORM\EntityManager;
use IdeasBucket\QueueBundle\Job\JobsInterface;
use IdeasBucket\QueueBundle\QueueableInterface;
use AppBundle\Entity\QueueJobMail;
use Swift_Message;

/**
 * Class ExecuteReportScript
 *
 * @package AppBundle\Job
 */
class ExecuteReportScript implements QueueableInterface
{

    private $entityManager;
    private $logger;
    private $mailer;
    private $router;
    private $webDirectory;

    public function __construct(EntityManager $entityManager, $logger, $mailer, $router, $webDirectory)
    {
        $this->entityManager = $entityManager;
        $this->logger = $logger;
        $this->mailer = $mailer;
        $this->router = $router;
        $this->webDirectory = $webDirectory;
    }

    /**
     * This job can be queued like this (assuming that you are inside the controller).
     *
     * $this->get('idb_queue')->push('appbundle.job.executereportscript', $data);
     *
     * OR If you want to use specific queue and connection then.
     *
     * $this->get('idb_queue')->push('appbundle.job.executereportscript', $data, 'some_queue', 'database');
     *
     * @param JobsInterface $job
     * @param mixed         $data
     */
    public function fire(JobsInterface $job, $jobData = null)
    {
        try {
            set_time_limit(6000);
            ini_set('mysql.connect_timeout', '6000');
            ini_set('max_execution_time', '6000');
            ini_set('memory_limit', '-1');

            $entity = $this->entityManager->getRepository('AppBundle:ReportScript')->findOneBySlug($jobData['slug']);

            $queueJobMail = new QueueJobMail();
            $queueJobMail->setReport($entity->getName());
            $queueJobMail->setEmail($jobData['email']);
            $queueJobMail->setSended(false);

            $entity->setIsRunning(true);
            $this->entityManager->flush();

            $this->logger->log('error', "JOB - Data \r\n ".json_encode($jobData));

            $this->logger->log('error', "JOB - Execute query");
            $this->logger->log('error', $jobData['script']);

            $job->delete();

            $statement = $this->entityManager->getConnection()->prepare($jobData['script']);
            $statement->execute();
            $list = $statement->fetchAll();

            $rows = array();

            if (count($list) > 0) {
                $headers = array_keys($list[0]);
                foreach ($list as $value) {
                    $data = array();
                    foreach ($headers as $header) {
                        $data[] = $value[$header];
                    }
                    $rows[] = implode(',', $data);
                }
                $contentHeader = implode(',', $headers);
                $contentBody = implode("\n", $rows);
                $content = $contentHeader . "\n" . $contentBody;

                
                $uploadPath = '/uploads/reports/' . $jobData['slug']."-".strtotime("now"). '.csv';
                $reportPath = $this->webDirectory . $uploadPath;
                $this->logger->log('error', "JOB - Save File - ".$uploadPath);

                $reportFile = fopen($reportPath, 'w');
                $result = fwrite($reportFile, $content);
                fclose($reportFile);

                if (!$result) {
                    $this->logger->log('error', 'JOB - Error saving file - '.$uploadPath);
                } else {
                    $this->logger->log('error', "JOB - Create Queue Job Mail - " . $jobData['email']);
                    $queueJobMail->setPathFile($uploadPath);
                    $queueJobMail->setErrorExecution(false);
                    // $message = (new Swift_Message('Relatório gerado com sucesso - ' . $entity->getName()))
                    //     ->setFrom('no-reply@lmssambatech.com.br')
                    //     ->setTo($jobData['email'])
                    //     // ->setBody('<p>O relatório já pode ser baixado pelo link abaixo</p>
                    //     // <a href="https://lmssambatech.com.br' . $uploadPath . '">Baixar arquivo</a>', 'text/html');
                    //     ->setBody('<p>O relatório já pode ser baixado pelo link abaixo</p>
                    //     <a href="https://unimed.meuteste.dev.br' . $uploadPath . '">Baixar arquivo</a>', 'text/html');

                    // $this->mailer->send($message);
                }
            }else{
                $this->logger->log('error', "JOB - Send mail - empty report");
                $queueJobMail->setObservation("O relatório foi gerado, porém nenhuma informação foi encontrada com o script informado.");
                $queueJobMail->setErrorExecution(false);
                // $message = (new Swift_Message('Relatório Vazio - ' . $entity->getName()))
                //         ->setFrom('no-reply@lmssambatech.com.br')
                //         ->setTo($jobData['email'])
                //         ->setBody('<p>O relatório foi gerado, porém nenhuma informação foi encontrada com o script informado.</p>', 
                //         'text/html');

                // $this->mailer->send($message);
            }
            $this->entityManager->persist($queueJobMail);
            $entity->setIsRunning(false);
            $this->entityManager->flush();
            // $job->delete();
        } catch (\Exception $e) {
            $this->logger->log('error', $e->getMessage());

            // $message = (new Swift_Message('Erro ao gerar relatório - ' . $entity->getName()))
            //             ->setFrom('no-reply@lmssambatech.com.br')
            //             ->setTo($jobData['email'])
            //             ->setBody('<p>O relatório não foi gerado corretamente. Segue o erro abaixo</p>' . 
            //             $e->getMessage(), 'text/html');

            // $this->mailer->send($message);
            
            $queueJobMail->setObservation($e->getMessage());
            $queueJobMail->setErrorExecution(true);
            $this->entityManager->persist($queueJobMail);
            $entity = $this->entityManager->getRepository('AppBundle:ReportScript')->findOneBySlug($jobData['slug']);

            $entity->setIsRunning(false);
            $this->entityManager->flush();
        }
    }
}
