<?php

namespace AppBundle\Listener;

use Symfony\Component\Security\Core\SecurityContextInterface;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\Security\Http\Event\InteractiveLoginEvent;
use Symfony\Component\DependencyInjection\ContainerInterface;

class SecurityListener
{
    protected $security;
    protected $session;
    protected $logger;
    protected $container;

    public function __construct(SecurityContextInterface $security, ContainerInterface $container, Session $session, $logger)
    {
        $this->security  = $security;
        $this->session   = $session;
        $this->logger    = $logger;
        $this->container = $container;
    }

    public function onSecurityInteractiveLogin(InteractiveLoginEvent $event)
    {
        // $this->logger->log('error', 'Teste SecurityListener');
        // $user = $this->getUser();
        $user = $this->security->getToken()->getUser();
        $userPermissions = $user->getPermissions();
        $permissionsData = $this->getPermissionsData($userPermissions);
        $this->session->set('user_access_permissions', $permissionsData);

        // pegar as empresas e setar tbm
        $enterprisesData = $this->getEnterprisesInPermissionsUser($userPermissions);
        $this->session->set('user_access_enterprises', $enterprisesData);

        // $this->logger->log('error', json_encode($enterprisesData));
        // $this->logger->log('error', count($userPermissions));
    }

    public function getEnterprisesInPermissionsUser($permissions)
    {
        $enterprisesPermission = array();

        if (count($permissions) > 0) {
            foreach ($permissions as $userAccessControl) {
                $enterprises = $userAccessControl->getAccessControl()->getEnterprises();
                // $this->logger->log('error', count($enterprises));
                if (count($enterprises) > 0) {
                    foreach ($enterprises as $enterpriseAccessControl) {
                        $enterprisesPermission[] = $enterpriseAccessControl->getEnterprise();
                    }
                }
            }
        }

        return $enterprisesPermission;
    }

    public function getPermissionsData($userPermissions)
    {
        $permissionsData = array();

        if (count($userPermissions) > 0) {
            foreach ($userPermissions as $userAccessControl) {
                $accessPermissions = $userAccessControl->getAccessControl()->getAccessPermissions();

                if (count($accessPermissions) > 0) {
                    foreach ($accessPermissions as $accessPermissionControl) {
                        $permissionsData[] = array(
                            'permission' => $accessPermissionControl->getAccessControl()->getPermission(),
                            'guard' => $accessPermissionControl->getPermissionControl()->getGuard()
                        );
                    }
                }
            }
        }

        return $permissionsData;
    }
}
