<?php

namespace AppBundle\Repository;

/**
 * AnswerRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class AnswerRepository extends \Doctrine\ORM\EntityRepository
{

    /**
     * Adiciona filtros para selecionar apenas registros ativos à query.
     * @param QueryBuilder $qb Query inicial.
     * @return QueryBuilder Query com filtros.
     */
    public function addActiveQuery(QueryBuilder $qb = null) {
        $em = $this->getEntityManager();

        if (is_null($qb)) {
            $qb = $em->createQueryBuilder();
        }

        $qb->select(array('a'))
            ->from('AppBundle:Answer', 'a');

        return $qb;
    }

    /**
    * Busca todas as respostas a partir dos dados informados
    * @param User $user Usuário corrente.
    * @param Question $question Questão respondida
    * @return array Array de registros.
    */
    public function findAnswerByUserQuestion($user, $question){
      $qb = $this->addActiveQuery();

      $qb->andWhere("a.userEvaluation = :user")->setParameter("user", $user);
      $qb->andWhere("a.question = :question")->setParameter("question", $question);

      $qb->setMaxResults(1);

      return $qb->getQuery()->getOneOrNullResult();;
    }

    public function findTotalCorrectAnswer($user){
        $qb = $this->addActiveQuery();
        $qb->select('count(a.id) as totalCorrectQuestions');

        $qb->andWhere("a.userEvaluation = :user")->setParameter("user", $user);
        $qb->andWhere("a.correctAnswer = 1");

        return $qb->getQuery()->getSingleScalarResult();
    }

}
